/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng.stack;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.fluids.util.AEFluidStack;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class WrappedFluidStack
implements IAEFluidStack {
    @NotNull
    FluidStack delegate;

    private WrappedFluidStack(@NotNull FluidStack stack) {
        this.delegate = stack;
    }

    public static WrappedFluidStack fromFluidStack(FluidStack fluidStack) {
        return fluidStack == null ? null : new WrappedFluidStack(fluidStack);
    }

    public static WrappedFluidStack fromNBT(NBTTagCompound data) {
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data);
        return WrappedFluidStack.fromFluidStack(fluidStack);
    }

    public static WrappedFluidStack fromPacket(ByteBuf buffer) {
        byte len = buffer.readByte();
        byte[] name = new byte[len];
        buffer.readBytes(name, 0, (int)len);
        int amt = buffer.readInt();
        FluidStack fluidStack = FluidRegistry.getFluidStack((String)new String(name, StandardCharsets.UTF_8), (int)amt);
        return WrappedFluidStack.fromFluidStack(fluidStack);
    }

    public AEFluidStack getAEStack() {
        return AEFluidStack.fromFluidStack((FluidStack)this.delegate);
    }

    @NotNull
    public FluidStack getDelegate() {
        return this.delegate;
    }

    public FluidStack getFluidStack() {
        return this.delegate.copy();
    }

    public void add(IAEFluidStack iaeFluidStack) {
        this.delegate.amount = (int)((long)this.delegate.amount + iaeFluidStack.getStackSize());
    }

    public long getStackSize() {
        return this.delegate.amount;
    }

    public IAEFluidStack setStackSize(long l) {
        this.delegate.amount = (int)l;
        return this;
    }

    public long getCountRequestable() {
        return 0L;
    }

    public IAEFluidStack setCountRequestable(long l) {
        return this;
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEFluidStack setCraftable(boolean b) {
        return this;
    }

    public IAEFluidStack reset() {
        this.delegate.amount = 0;
        return this;
    }

    public boolean isMeaningful() {
        return this.delegate.amount > 0;
    }

    public void incStackSize(long l) {
        this.delegate.amount = (int)((long)this.delegate.amount + l);
    }

    public void decStackSize(long l) {
        this.delegate.amount = (int)((long)this.delegate.amount - l);
    }

    public void incCountRequestable(long l) {
    }

    public void decCountRequestable(long l) {
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        this.delegate.writeToNBT(nbtTagCompound);
    }

    public boolean fuzzyComparison(IAEFluidStack stack, FuzzyMode fuzzyMode) {
        return this.delegate.getFluid() == stack.getFluid();
    }

    public void writeToPacket(ByteBuf buffer) {
        byte[] name = this.delegate.getFluid().getName().getBytes(StandardCharsets.UTF_8);
        buffer.writeByte((int)((byte)name.length));
        buffer.writeBytes(name);
        buffer.writeInt(this.delegate.amount);
    }

    public IAEFluidStack copy() {
        return new WrappedFluidStack(this.delegate.copy());
    }

    public IAEFluidStack empty() {
        WrappedFluidStack dup = new WrappedFluidStack(this.delegate.copy());
        dup.reset();
        return dup;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isFluid() {
        return true;
    }

    public IStorageChannel<IAEFluidStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    public ItemStack asItemStackRepresentation() {
        return ItemStack.field_190927_a;
    }

    public Fluid getFluid() {
        return this.delegate.getFluid();
    }

    public boolean equals(Object other) {
        if (other instanceof WrappedFluidStack) {
            return ((WrappedFluidStack)other).delegate.isFluidEqual(this.delegate);
        }
        if (other instanceof FluidStack) {
            return ((FluidStack)other).isFluidEqual(this.delegate);
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.delegate.getFluid().hashCode();
        result = 31 * result + (this.delegate.tag == null ? 0 : this.delegate.tag.hashCode());
        return result;
    }
}

