/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng.slot;

import appeng.api.storage.data.IAEItemStack;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAESlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedItemStack;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ExportOnlyAEItemSlot
extends ExportOnlyAESlot<IAEItemStack>
implements IItemHandlerModifiable {
    protected Consumer<Integer> trigger;

    public ExportOnlyAEItemSlot(IAEItemStack config, IAEItemStack stock) {
        super(config, stock);
    }

    public ExportOnlyAEItemSlot() {
    }

    public void setTrigger(Consumer<Integer> trigger) {
        this.trigger = trigger;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("config")) {
            this.config = WrappedItemStack.fromNBT(nbt.func_74775_l("config"));
        }
        if (nbt.func_74764_b("stock")) {
            this.stock = WrappedItemStack.fromNBT(nbt.func_74775_l("stock"));
        }
    }

    public ExportOnlyAEItemSlot copy() {
        return new ExportOnlyAEItemSlot(this.config == null ? null : ((IAEItemStack)this.config).copy(), this.stock == null ? null : ((IAEItemStack)this.stock).copy());
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot == 0 && this.stock != null) {
            return ((IAEItemStack)this.stock).getDefinition();
        }
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0 && this.stock != null) {
            int extracted = (int)Math.min(((IAEItemStack)this.stock).getStackSize(), (long)amount);
            ItemStack result = ((IAEItemStack)this.stock).createItemStack();
            result.func_190920_e(extracted);
            if (!simulate) {
                ((IAEItemStack)this.stock).decStackSize((long)extracted);
                if (((IAEItemStack)this.stock).getStackSize() == 0L) {
                    this.stock = null;
                }
            }
            if (this.trigger != null) {
                this.trigger.accept(0);
            }
            return result;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IAEItemStack requestStack() {
        IAEItemStack result = (IAEItemStack)super.requestStack();
        if (result instanceof WrappedItemStack) {
            return ((WrappedItemStack)result).getAEStack();
        }
        return result;
    }

    @Override
    public IAEItemStack exceedStack() {
        IAEItemStack result = (IAEItemStack)super.exceedStack();
        if (result instanceof WrappedItemStack) {
            return ((WrappedItemStack)result).getAEStack();
        }
        return result;
    }

    @Override
    public void addStack(IAEItemStack stack) {
        if (this.stock == null) {
            this.stock = WrappedItemStack.fromItemStack(stack.createItemStack());
        } else {
            ((IAEItemStack)this.stock).add(stack);
        }
        this.trigger.accept(0);
    }

    @Override
    public void setStack(IAEItemStack stack) {
        if (this.stock == null && stack == null) {
            return;
        }
        this.stock = stack == null ? null : WrappedItemStack.fromItemStack(stack.createItemStack());
        this.trigger.accept(0);
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }
}

