/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng.slot;

import appeng.api.storage.data.IAEItemStack;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEItemSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class ExportOnlyAEItemList
extends NotifiableItemStackHandler {
    protected final int size;
    protected ExportOnlyAEItemSlot[] inventory;

    public ExportOnlyAEItemList(MetaTileEntity holder, int slots, MetaTileEntity entityToNotify) {
        super(holder, slots, entityToNotify, false);
        this.size = slots;
        this.createInventory(holder);
    }

    protected void createInventory(MetaTileEntity holder) {
        this.inventory = new ExportOnlyAEItemSlot[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.inventory[i] = new ExportOnlyAEItemSlot();
        }
        for (ExportOnlyAEItemSlot slot : this.inventory) {
            slot.setTrigger(this::onContentsChanged);
        }
    }

    public ExportOnlyAEItemSlot[] getInventory() {
        return this.inventory;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (int index = 0; index < this.size; ++index) {
            if (!nbt.func_74764_b("#" + index)) continue;
            NBTTagCompound slotTag = nbt.func_74775_l("#" + index);
            this.inventory[index].deserializeNBT(slotTag);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int index = 0; index < this.size; ++index) {
            NBTTagCompound slot = this.inventory[index].serializeNBT();
            nbt.func_74782_a("#" + index, (NBTBase)slot);
        }
        return nbt;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
    }

    public int getSlots() {
        return this.size;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= 0 && slot < this.size) {
            return this.inventory[slot].getStackInSlot(0);
        }
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= 0 && slot < this.size) {
            return this.inventory[slot].extractItem(0, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public void clearConfig() {
        for (ExportOnlyAEItemSlot slot : this.inventory) {
            slot.setConfig(null);
            slot.setStock(null);
        }
    }

    public boolean hasStackInConfig(ItemStack stack, boolean checkExternal) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        for (ExportOnlyAEItemSlot slot : this.inventory) {
            IAEItemStack config = (IAEItemStack)slot.getConfig();
            if (config == null || !config.isSameType(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoPull() {
        return false;
    }

    public boolean isStocking() {
        return false;
    }
}

