/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.config.Actionable;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEInputBus;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEItemList;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEItemSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedItemStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMEStockingBus
extends MetaTileEntityMEInputBus {
    private static final int CONFIG_SIZE = 16;
    private boolean autoPull;
    private Predicate<ItemStack> autoPullTest = $ -> false;

    public MetaTileEntityMEStockingBus(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 6);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityMEStockingBus(this.metaTileEntityId);
    }

    @Override
    protected ExportOnlyAEStockingItemList getAEItemHandler() {
        if (this.aeItemHandler == null) {
            this.aeItemHandler = new ExportOnlyAEStockingItemList(this, 16, (MetaTileEntity)this.getController());
        }
        return (ExportOnlyAEStockingItemList)this.aeItemHandler;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.isWorkingEnabled() && this.autoPull && this.getOffsetTimer() % 100L == 0L) {
            this.refreshList();
            this.syncME();
        }
    }

    @Override
    protected void syncME() {
        IMEMonitor monitor = super.getMonitor();
        if (monitor == null) {
            return;
        }
        for (ExportOnlyAEStockingItemSlot slot : this.getAEItemHandler().getInventory()) {
            IAEItemStack request;
            if (slot.getConfig() == null) {
                slot.setStack((IAEItemStack)null);
                continue;
            }
            Object t = slot.getConfig();
            if (t instanceof WrappedItemStack) {
                WrappedItemStack wis = (WrappedItemStack)t;
                request = wis.getAEStack();
            } else {
                request = ((IAEItemStack)slot.getConfig()).copy();
            }
            request.setStackSize(Integer.MAX_VALUE);
            IAEItemStack result = (IAEItemStack)monitor.extractItems((IAEStack)request, Actionable.SIMULATE, this.getActionSource());
            slot.setStack(result);
        }
    }

    @Override
    protected void flushInventory() {
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        this.autoPullTest = stack -> !this.testConfiguredInOtherBus((ItemStack)stack);
        this.validateConfig();
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        this.autoPullTest = $ -> false;
        if (this.autoPull) {
            this.getAEItemHandler().clearConfig();
        }
        super.removeFromMultiBlock(controllerBase);
    }

    @Override
    public void onDistinctChange(boolean newValue) {
        super.onDistinctChange(newValue);
        if (!this.getWorld().field_72995_K && !newValue) {
            this.validateConfig();
        }
    }

    private void validateConfig() {
        for (ExportOnlyAEStockingItemSlot slot : this.getAEItemHandler().getInventory()) {
            ItemStack configuredStack;
            if (slot.getConfig() == null || !this.testConfiguredInOtherBus(configuredStack = ((IAEItemStack)slot.getConfig()).createItemStack())) continue;
            slot.setConfig(null);
            slot.setStock(null);
        }
    }

    private boolean testConfiguredInOtherBus(ItemStack stack) {
        RecipeMapMultiblockController rmmc;
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        MultiblockControllerBase controller = this.getController();
        if (controller == null) {
            return false;
        }
        if (!(controller instanceof RecipeMapMultiblockController) || !(rmmc = (RecipeMapMultiblockController)controller).isDistinct()) {
            List<IItemHandlerModifiable> abilityList = controller.getAbilities(MultiblockAbility.IMPORT_ITEMS);
            for (IItemHandlerModifiable ability : abilityList) {
                ExportOnlyAEStockingItemList aeList;
                if (!(ability instanceof ExportOnlyAEStockingItemList) || (aeList = (ExportOnlyAEStockingItemList)ability) == this.aeItemHandler || !aeList.hasStackInConfig(stack, false)) continue;
                return true;
            }
        }
        return false;
    }

    private void setAutoPull(boolean autoPull) {
        this.autoPull = autoPull;
        this.markDirty();
        if (!this.getWorld().field_72995_K) {
            if (!this.autoPull) {
                this.getAEItemHandler().clearConfig();
            } else if (this.updateMEStatus()) {
                this.refreshList();
                this.syncME();
            }
            this.writeCustomData(GregtechDataCodes.UPDATE_AUTO_PULL, buf -> buf.writeBoolean(this.autoPull));
        }
    }

    private void refreshList() {
        IMEMonitor monitor = this.getMonitor();
        if (monitor == null) {
            this.clearInventory(0);
            return;
        }
        IItemList storageList = monitor.getStorageList();
        if (storageList == null) {
            this.clearInventory(0);
            return;
        }
        int index = 0;
        for (IAEItemStack stack : storageList) {
            WrappedItemStack selectedStack;
            ItemStack itemStack;
            if (index >= 16) break;
            if (stack.getStackSize() == 0L || (stack = (IAEItemStack)monitor.extractItems((IAEStack)stack, Actionable.SIMULATE, this.getActionSource())) == null || stack.getStackSize() == 0L || (itemStack = stack.createItemStack()) == null || itemStack.func_190926_b() || this.autoPullTest != null && !this.autoPullTest.test(itemStack) || (selectedStack = WrappedItemStack.fromItemStack(itemStack)) == null) continue;
            IAEItemStack configStack = (IAEItemStack)selectedStack.copy().setStackSize(1L);
            ExportOnlyAEStockingItemSlot slot = this.getAEItemHandler().getInventory()[index];
            slot.setConfig(configStack);
            slot.setStack(selectedStack);
            ++index;
        }
        this.clearInventory(index);
    }

    private void clearInventory(int startIndex) {
        for (int i = startIndex; i < 16; ++i) {
            ExportOnlyAEStockingItemSlot slot = this.getAEItemHandler().getInventory()[i];
            slot.setConfig(null);
            slot.setStack((IAEItemStack)null);
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_AUTO_PULL) {
            this.autoPull = buf.readBoolean();
        }
    }

    @Override
    protected ModularUI.Builder createUITemplate(EntityPlayer player) {
        ModularUI.Builder builder = super.createUITemplate(player);
        builder.widget(new ImageCycleButtonWidget(80, 26, 16, 16, GuiTextures.BUTTON_AUTO_PULL, () -> this.autoPull, this::setAutoPull).setTooltipHoverString("gregtech.gui.me_bus.auto_pull_button"));
        return builder;
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!this.getWorld().field_72995_K) {
            this.setAutoPull(!this.autoPull);
            if (this.autoPull) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.me.stocking_auto_pull_enabled", new Object[0]), false);
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.me.stocking_auto_pull_disabled", new Object[0]), false);
            }
        }
        return true;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("AutoPull", this.autoPull);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.autoPull = data.func_74767_n("AutoPull");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.autoPull);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.autoPull = buf.readBoolean();
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_bus.import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.stocking_item.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me_import_item_hatch.configs.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.copy_paste.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.stocking_item.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    protected NBTTagCompound writeConfigToTag() {
        if (!this.autoPull) {
            NBTTagCompound tag = super.writeConfigToTag();
            tag.func_74757_a("AutoPull", false);
            return tag;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("AutoPull", true);
        tag.func_74774_a("GhostCircuit", (byte)this.circuitInventory.getCircuitValue());
        return tag;
    }

    @Override
    protected void readConfigFromTag(NBTTagCompound tag) {
        if (tag.func_74767_n("AutoPull")) {
            this.setAutoPull(true);
            this.setGhostCircuitConfig(tag.func_74771_c("GhostCircuit"));
            return;
        }
        this.setAutoPull(false);
        super.readConfigFromTag(tag);
    }

    private static class ExportOnlyAEStockingItemList
    extends ExportOnlyAEItemList {
        private final MetaTileEntityMEStockingBus holder;

        public ExportOnlyAEStockingItemList(MetaTileEntityMEStockingBus holder, int slots, MetaTileEntity entityToNotify) {
            super(holder, slots, entityToNotify);
            this.holder = holder;
        }

        @Override
        protected void createInventory(MetaTileEntity holder) {
            if (!(holder instanceof MetaTileEntityMEStockingBus)) {
                throw new IllegalArgumentException("Cannot create Stocking Item List for nonstocking MetaTileEntity!");
            }
            MetaTileEntityMEStockingBus stocking = (MetaTileEntityMEStockingBus)holder;
            this.inventory = new ExportOnlyAEStockingItemSlot[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.inventory[i] = new ExportOnlyAEStockingItemSlot(stocking);
            }
            for (ExportOnlyAEItemSlot slot : this.inventory) {
                slot.setTrigger(this::onContentsChanged);
            }
        }

        public ExportOnlyAEStockingItemSlot[] getInventory() {
            return (ExportOnlyAEStockingItemSlot[])super.getInventory();
        }

        @Override
        public boolean isStocking() {
            return true;
        }

        @Override
        public boolean isAutoPull() {
            return this.holder.autoPull;
        }

        @Override
        public boolean hasStackInConfig(ItemStack stack, boolean checkExternal) {
            boolean inThisBus = super.hasStackInConfig(stack, false);
            if (inThisBus) {
                return true;
            }
            if (checkExternal) {
                return this.holder.testConfiguredInOtherBus(stack);
            }
            return false;
        }
    }

    private static class ExportOnlyAEStockingItemSlot
    extends ExportOnlyAEItemSlot {
        private final MetaTileEntityMEStockingBus holder;

        public ExportOnlyAEStockingItemSlot(IAEItemStack config, IAEItemStack stock, MetaTileEntityMEStockingBus holder) {
            super(config, stock);
            this.holder = holder;
        }

        public ExportOnlyAEStockingItemSlot(MetaTileEntityMEStockingBus holder) {
            this.holder = holder;
        }

        @Override
        public ExportOnlyAEStockingItemSlot copy() {
            return new ExportOnlyAEStockingItemSlot(this.config == null ? null : ((IAEItemStack)this.config).copy(), this.stock == null ? null : ((IAEItemStack)this.stock).copy(), this.holder);
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 && this.stock != null && this.config != null) {
                IAEItemStack request;
                IMEMonitor monitor = this.holder.getMonitor();
                if (monitor == null) {
                    return ItemStack.field_190927_a;
                }
                Actionable action = simulate ? Actionable.SIMULATE : Actionable.MODULATE;
                IAEStack iAEStack = this.config;
                if (iAEStack instanceof WrappedItemStack) {
                    WrappedItemStack wis = (WrappedItemStack)iAEStack;
                    request = wis.getAEStack();
                } else {
                    request = ((IAEItemStack)this.config).copy();
                }
                request.setStackSize((long)amount);
                IAEItemStack result = (IAEItemStack)monitor.extractItems((IAEStack)request, action, this.holder.getActionSource());
                if (result != null) {
                    int extracted = (int)Math.min(result.getStackSize(), (long)amount);
                    ((IAEItemStack)this.stock).decStackSize((long)extracted);
                    if (this.trigger != null) {
                        this.trigger.accept(0);
                    }
                    if (extracted != 0) {
                        ItemStack resultStack = ((IAEItemStack)this.config).createItemStack();
                        resultStack.func_190920_e(extracted);
                        return resultStack;
                    }
                }
            }
            return ItemStack.field_190927_a;
        }
    }
}

