/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IRotorHolder;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.items.behaviors.AbstractMaterialPartBehavior;
import gregtech.common.items.behaviors.TurbineRotorBehavior;
import gregtech.common.metatileentities.multi.electric.generator.MetaTileEntityLargeTurbine;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import gregtech.core.advancement.AdvancementTriggers;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityRotorHolder
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IRotorHolder>,
IRotorHolder {
    static final int SPEED_INCREMENT = 1;
    static final int SPEED_DECREMENT = 3;
    private final InventoryRotorHolder inventory = new InventoryRotorHolder();
    private final int maxSpeed;
    private int currentSpeed;
    private int rotorColor = -1;
    private boolean isRotorSpinning;
    private boolean frontFaceFree;

    public MetaTileEntityRotorHolder(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier, false);
        this.maxSpeed = 2000 + 1000 * tier;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityRotorHolder(this.metaTileEntityId, this.getTier());
    }

    @Override
    public IItemHandlerModifiable getImportItems() {
        return this.inventory;
    }

    @Override
    protected ModularUI createUI(@NotNull EntityPlayer entityPlayer) {
        return ModularUI.defaultBuilder().label(6, 6, this.getMetaFullName()).slot((IItemHandlerModifiable)this.inventory, 0, 79, 36, GuiTextures.SLOT, GuiTextures.TURBINE_OVERLAY).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.rotor_holder.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.rotor_holder.tooltip2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.disabled", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public MultiblockAbility<IRotorHolder> getAbility() {
        return MultiblockAbility.ROTOR_HOLDER;
    }

    @Override
    public void update() {
        MetaTileEntityLargeTurbine controller;
        boolean isFrontFree;
        super.update();
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.getOffsetTimer() % 20L == 0L && (isFrontFree = this.checkTurbineFaceFree()) != this.frontFaceFree) {
            this.frontFaceFree = isFrontFree;
            this.writeCustomData(GregtechDataCodes.FRONT_FACE_FREE, buf -> buf.writeBoolean(this.frontFaceFree));
        }
        if ((controller = (MetaTileEntityLargeTurbine)this.getController()) != null && controller.isActive()) {
            if (this.currentSpeed < this.maxSpeed) {
                this.setCurrentSpeed(this.currentSpeed + 1);
            }
            if (this.getOffsetTimer() % 20L == 0L) {
                this.damageRotor(1 + controller.getNumMaintenanceProblems());
            }
        } else if (!this.hasRotor()) {
            this.setCurrentSpeed(0);
        } else if (this.currentSpeed > 0) {
            this.setCurrentSpeed(Math.max(0, this.currentSpeed - 3));
        }
    }

    void setCurrentSpeed(int speed) {
        if (this.currentSpeed != speed) {
            this.currentSpeed = speed;
            this.setRotorSpinning(this.currentSpeed > 0);
            this.markDirty();
        }
    }

    void setRotorSpinning(boolean spinning) {
        if (this.isRotorSpinning != spinning) {
            this.isRotorSpinning = spinning;
            this.writeCustomData(GregtechDataCodes.IS_ROTOR_LOOPING, buf -> buf.writeBoolean(this.isRotorSpinning));
        }
    }

    @Override
    public void registerAbilities(@NotNull List<IRotorHolder> abilityList) {
        abilityList.add(this);
    }

    @Override
    public boolean canPartShare() {
        return false;
    }

    @Override
    public boolean isFrontFaceFree() {
        return this.frontFaceFree;
    }

    private boolean checkTurbineFaceFree() {
        EnumFacing front = this.getFrontFacing();
        EnumFacing upwards = front.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.UP;
        for (int left = -1; left <= 1; ++left) {
            for (int up = -1; up <= 1; ++up) {
                BlockPos checkPos = RelativeDirection.offsetPos(this.getPos(), front, upwards, false, up, left, 1);
                IBlockState state = this.getWorld().func_180495_p(checkPos);
                if (state.func_177230_c().isAir(state, (IBlockAccess)this.getWorld(), checkPos)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean onRotorHolderInteract(@NotNull EntityPlayer player) {
        if (player.func_184812_l_()) {
            return false;
        }
        if (!this.getWorld().field_72995_K && this.isRotorSpinning) {
            float damageApplied = Math.min(1, this.currentSpeed / 1000);
            player.func_70097_a(DamageSources.getTurbineDamage(), damageApplied);
            AdvancementTriggers.ROTOR_HOLDER_DEATH.trigger((EntityPlayerMP)player);
            return true;
        }
        return this.isRotorSpinning;
    }

    @Override
    public boolean hasRotor() {
        return this.rotorColor != -1;
    }

    protected void setRotorColor(int color) {
        this.rotorColor = color;
    }

    protected int getRotorColor() {
        return this.rotorColor;
    }

    @Override
    public int getRotorSpeed() {
        return this.currentSpeed;
    }

    @Override
    public int getRotorEfficiency() {
        return this.inventory.getRotorEfficiency();
    }

    @Override
    public int getRotorPower() {
        return this.inventory.getRotorPower();
    }

    @Override
    public int getRotorDurabilityPercent() {
        return this.inventory.getRotorDurabilityPercent();
    }

    @Override
    public void damageRotor(int amount) {
        this.inventory.damageRotor(amount);
    }

    @Override
    public int getMaxRotorHolderSpeed() {
        return this.maxSpeed;
    }

    @Override
    public int getHolderPowerMultiplier() {
        int tierDifference = this.getTierDifference();
        if (tierDifference == -1) {
            return -1;
        }
        return (int)Math.pow(2.0, this.getTierDifference());
    }

    @Override
    public int getHolderEfficiency() {
        int tierDifference = this.getTierDifference();
        if (tierDifference == -1) {
            return -1;
        }
        return 100 + 10 * tierDifference;
    }

    private int getTierDifference() {
        if (this.getController() instanceof ITieredMetaTileEntity) {
            return this.getTier() - ((ITieredMetaTileEntity)((Object)this.getController())).getTier();
        }
        return -1;
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return this.onRotorHolderInteract(playerIn) || super.onRightClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return this.onRotorHolderInteract(playerIn) || super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return this.onRotorHolderInteract(playerIn);
    }

    @Override
    public void onLeftClick(EntityPlayer player, EnumFacing facing, CuboidRayTraceResult hitResult) {
        this.onRotorHolderInteract(player);
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityRotorHolder.clearInventory(itemBuffer, this.inventory);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        data.func_74768_a("currentSpeed", this.currentSpeed);
        data.func_74757_a("Spinning", this.isRotorSpinning);
        data.func_74757_a("FrontFree", this.frontFaceFree);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.deserializeNBT(data.func_74775_l("inventory"));
        this.currentSpeed = data.func_74762_e("currentSpeed");
        this.isRotorSpinning = data.func_74767_n("Spinning");
        this.frontFaceFree = data.func_74767_n("FrontFree");
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.IS_ROTOR_LOOPING) {
            this.isRotorSpinning = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.FRONT_FACE_FREE) {
            this.frontFaceFree = buf.readBoolean();
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isRotorSpinning);
        buf.writeInt(this.rotorColor);
        buf.writeBoolean(this.frontFaceFree);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isRotorSpinning = buf.readBoolean();
        this.rotorColor = buf.readInt();
        this.frontFaceFree = buf.readBoolean();
        this.scheduleRenderUpdate();
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.ROTOR_HOLDER_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        Textures.LARGE_TURBINE_ROTOR_RENDERER.renderSided(renderState, translation, pipeline, this.getFrontFacing(), this.getController() != null, this.hasRotor(), this.isRotorSpinning, this.getRotorColor());
    }

    private class InventoryRotorHolder
    extends NotifiableItemStackHandler {
        public InventoryRotorHolder() {
            super(MetaTileEntityRotorHolder.this, 1, null, false);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onLoad() {
            MetaTileEntityRotorHolder.this.rotorColor = this.getRotorColor();
        }

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            MetaTileEntityRotorHolder.this.setRotorColor(this.getRotorColor());
            MetaTileEntityRotorHolder.this.scheduleRenderUpdate();
        }

        @Nullable
        private ItemStack getTurbineStack() {
            if (!this.hasRotor()) {
                return null;
            }
            return this.getStackInSlot(0);
        }

        @Nullable
        private TurbineRotorBehavior getTurbineBehavior() {
            ItemStack stack = this.getStackInSlot(0);
            if (stack.func_190926_b()) {
                return null;
            }
            return TurbineRotorBehavior.getInstanceFor(stack);
        }

        private boolean hasRotor() {
            return this.getTurbineBehavior() != null;
        }

        private int getRotorColor() {
            if (!this.hasRotor()) {
                return -1;
            }
            this.getTurbineBehavior();
            return TurbineRotorBehavior.getPartMaterial(this.getStackInSlot(0)).getMaterialRGB();
        }

        private int getRotorDurabilityPercent() {
            if (!this.hasRotor()) {
                return 0;
            }
            return this.getTurbineBehavior().getRotorDurabilityPercent(this.getStackInSlot(0));
        }

        private int getRotorEfficiency() {
            if (!this.hasRotor()) {
                return -1;
            }
            this.getTurbineBehavior();
            return TurbineRotorBehavior.getRotorEfficiency(this.getTurbineStack());
        }

        private int getRotorPower() {
            if (!this.hasRotor()) {
                return -1;
            }
            this.getTurbineBehavior();
            return TurbineRotorBehavior.getRotorPower(this.getTurbineStack());
        }

        private void damageRotor(int damageAmount) {
            MultiblockFuelRecipeLogic holder;
            if (!this.hasRotor()) {
                return;
            }
            if (this.getTurbineBehavior().getPartMaxDurability(this.getTurbineStack()) <= AbstractMaterialPartBehavior.getPartDamage(this.getTurbineStack()) + damageAmount && (holder = (MultiblockFuelRecipeLogic)MetaTileEntityRotorHolder.this.getController().getRecipeLogic()) != null && holder.isWorking()) {
                holder.invalidate();
            }
            this.getTurbineBehavior().applyRotorDamage(this.getStackInSlot(0), damageAmount);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return TurbineRotorBehavior.getInstanceFor(stack) != null && super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack itemStack = super.extractItem(slot, amount, simulate);
            if (!simulate && itemStack != ItemStack.field_190927_a) {
                MetaTileEntityRotorHolder.this.setRotorColor(-1);
            }
            return itemStack;
        }
    }
}

