/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOrientedCubeRenderer;
import gregtech.client.renderer.texture.custom.FireboxActiveRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class MetaTileEntityMultiblockPart
extends MetaTileEntity
implements IMultiblockPart,
ITieredMetaTileEntity {
    private final int tier;
    private BlockPos controllerPos;
    private MultiblockControllerBase controllerTile;
    protected ICubeRenderer hatchTexture = null;

    public MetaTileEntityMultiblockPart(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId);
        this.tier = tier;
        this.initializeInventory();
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getBaseTexture().getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        ICubeRenderer baseTexture = this.getBaseTexture();
        pipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        if (baseTexture instanceof FireboxActiveRenderer || baseTexture instanceof SimpleOrientedCubeRenderer) {
            baseTexture.renderOriented(renderState, translation, pipeline, this.getFrontFacing());
        } else {
            baseTexture.render(renderState, translation, pipeline);
        }
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public MultiblockControllerBase getController() {
        if (this.getWorld() != null && this.getWorld().field_72995_K && this.controllerTile == null && this.controllerPos != null) {
            this.controllerTile = (MultiblockControllerBase)GTUtility.getMetaTileEntity((IBlockAccess)this.getWorld(), this.controllerPos);
        }
        if (!(this.controllerTile == null || this.controllerTile.getHolder() != null && this.controllerTile.isValid() && (this.getWorld().field_72995_K || this.controllerTile.getMultiblockParts().contains(this)))) {
            this.controllerTile = null;
        }
        return this.controllerTile;
    }

    public ICubeRenderer getBaseTexture() {
        MultiblockControllerBase controller = this.getController();
        if (controller != null) {
            this.hatchTexture = controller.getBaseTexture(this);
            return this.hatchTexture;
        }
        if (this.hatchTexture != null) {
            if (this.hatchTexture != Textures.getInactiveTexture(this.hatchTexture)) {
                this.hatchTexture = Textures.getInactiveTexture(this.hatchTexture);
                return this.hatchTexture;
            }
            return this.hatchTexture;
        }
        return Textures.VOLTAGE_CASINGS[this.tier];
    }

    public boolean shouldRenderOverlay() {
        MultiblockControllerBase controller = this.getController();
        return controller == null || controller.shouldRenderOverlay(this);
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        MultiblockControllerBase controller = this.getController();
        buf.writeBoolean(controller != null);
        if (controller != null) {
            buf.func_179255_a(controller.getPos());
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        if (buf.readBoolean()) {
            this.controllerPos = buf.func_179259_c();
            this.controllerTile = null;
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.SYNC_CONTROLLER) {
            if (buf.readBoolean()) {
                this.controllerPos = buf.func_179259_c();
                this.controllerTile = null;
            } else {
                this.controllerPos = null;
                this.controllerTile = null;
            }
            this.scheduleRenderUpdate();
        }
    }

    private void setController(MultiblockControllerBase controller1) {
        this.controllerTile = controller1;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.SYNC_CONTROLLER, writer -> {
                writer.writeBoolean(this.controllerTile != null);
                if (this.controllerTile != null) {
                    writer.func_179255_a(this.controllerTile.getPos());
                }
            });
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        MultiblockControllerBase controller = this.getController();
        if (!this.getWorld().field_72995_K && controller != null) {
            controller.invalidateStructure();
        }
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        this.setController(controllerBase);
        this.scheduleRenderUpdate();
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        this.setController(null);
        this.scheduleRenderUpdate();
    }

    @Override
    public boolean isAttachedToMultiBlock() {
        return this.getController() != null;
    }

    @Override
    public int getDefaultPaintingColor() {
        return !this.isAttachedToMultiBlock() && this.hatchTexture == null ? super.getDefaultPaintingColor() : 0xFFFFFF;
    }

    @Override
    public boolean getIsWeatherOrTerrainResistant() {
        MultiblockControllerBase controllerBase = this.getController();
        if (controllerBase == null) {
            return super.getIsWeatherOrTerrainResistant();
        }
        return controllerBase.isMultiblockPartWeatherResistant(this);
    }
}

