/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.utils.PipelineUtil;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityEnergyHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IEnergyContainer> {
    protected final boolean isExportHatch;
    protected final int amperage;
    protected final IEnergyContainer energyContainer;

    public MetaTileEntityEnergyHatch(ResourceLocation metaTileEntityId, int tier, int amperage, boolean isExportHatch) {
        super(metaTileEntityId, tier);
        this.isExportHatch = isExportHatch;
        this.amperage = amperage;
        if (isExportHatch) {
            this.energyContainer = EnergyContainerHandler.emitterContainer(this, GTValues.V[tier] * 64L * (long)amperage, GTValues.V[tier], amperage);
            ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s == this.getFrontFacing());
        } else {
            this.energyContainer = EnergyContainerHandler.receiverContainer(this, GTValues.V[tier] * 16L * (long)amperage, GTValues.V[tier], amperage);
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityEnergyHatch(this.metaTileEntityId, this.getTier(), this.amperage, this.isExportHatch);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            this.getOverlay().renderSided(this.getFrontFacing(), renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()]));
        }
    }

    @Override
    public void update() {
        super.update();
        this.checkWeatherOrTerrainExplosion(this.getTier(), this.getTier() * 10, this.energyContainer);
    }

    @NotNull
    private SimpleOverlayRenderer getOverlay() {
        if (this.isExportHatch) {
            if (this.amperage <= 2) {
                return Textures.ENERGY_OUT_MULTI;
            }
            if (this.amperage <= 4) {
                return Textures.ENERGY_OUT_HI;
            }
            if (this.amperage <= 16) {
                return Textures.ENERGY_OUT_ULTRA;
            }
            return Textures.ENERGY_OUT_MAX;
        }
        if (this.amperage <= 2) {
            return Textures.ENERGY_IN_MULTI;
        }
        if (this.amperage <= 4) {
            return Textures.ENERGY_IN_HI;
        }
        if (this.amperage <= 16) {
            return Textures.ENERGY_IN_ULTRA;
        }
        return Textures.ENERGY_IN_MAX;
    }

    @Override
    public MultiblockAbility<IEnergyContainer> getAbility() {
        return this.isExportHatch ? MultiblockAbility.OUTPUT_ENERGY : MultiblockAbility.INPUT_ENERGY;
    }

    @Override
    public void registerAbilities(List<IEnergyContainer> abilityList) {
        abilityList.add(this.energyContainer);
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        String tierName = GTValues.VNF[this.getTier()];
        this.addDescriptorTooltip(stack, world, tooltip, advanced);
        if (this.isExportHatch) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_out", (Object[])new Object[]{this.energyContainer.getOutputVoltage(), tierName}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_out_till", (Object[])new Object[]{this.energyContainer.getOutputAmperage()}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), tierName}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_in_till", (Object[])new Object[]{this.energyContainer.getInputAmperage()}));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    protected void addDescriptorTooltip(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        if (this.isExportHatch) {
            if (this.amperage > 2) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_hatch.output_hi_amp.tooltip", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_hatch.output.tooltip", (Object[])new Object[0]));
            }
        } else if (this.amperage > 2) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_hatch.input_hi_amp.tooltip", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.energy_hatch.input.tooltip", (Object[])new Object[0]));
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public boolean canRenderFrontFaceX() {
        return this.isExportHatch;
    }

    @Override
    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        if (this == MetaTileEntities.ENERGY_INPUT_HATCH[0]) {
            for (MetaTileEntityEnergyHatch metaTileEntityEnergyHatch : MetaTileEntities.ENERGY_INPUT_HATCH) {
                if (metaTileEntityEnergyHatch == null) continue;
                subItems.add((Object)metaTileEntityEnergyHatch.getStackForm());
            }
            for (MetaTileEntityEnergyHatch metaTileEntityEnergyHatch : MetaTileEntities.ENERGY_OUTPUT_HATCH) {
                if (metaTileEntityEnergyHatch == null) continue;
                subItems.add((Object)metaTileEntityEnergyHatch.getStackForm());
            }
            for (MetaTileEntityEnergyHatch metaTileEntityEnergyHatch : MetaTileEntities.ENERGY_INPUT_HATCH_4A) {
                if (metaTileEntityEnergyHatch == null) continue;
                subItems.add((Object)metaTileEntityEnergyHatch.getStackForm());
            }
            for (MetaTileEntityEnergyHatch metaTileEntityEnergyHatch : MetaTileEntities.ENERGY_INPUT_HATCH_16A) {
                if (metaTileEntityEnergyHatch == null) continue;
                subItems.add((Object)metaTileEntityEnergyHatch.getStackForm());
            }
            for (MetaTileEntityEnergyHatch metaTileEntityEnergyHatch : MetaTileEntities.ENERGY_OUTPUT_HATCH_4A) {
                if (metaTileEntityEnergyHatch == null) continue;
                subItems.add((Object)metaTileEntityEnergyHatch.getStackForm());
            }
            for (MetaTileEntityEnergyHatch metaTileEntityEnergyHatch : MetaTileEntities.ENERGY_OUTPUT_HATCH_16A) {
                if (metaTileEntityEnergyHatch == null) continue;
                subItems.add((Object)metaTileEntityEnergyHatch.getStackForm());
            }
            for (MetaTileEntityEnergyHatch metaTileEntityEnergyHatch : MetaTileEntities.SUBSTATION_ENERGY_INPUT_HATCH) {
                if (metaTileEntityEnergyHatch == null) continue;
                subItems.add((Object)metaTileEntityEnergyHatch.getStackForm());
            }
            for (MetaTileEntityEnergyHatch metaTileEntityEnergyHatch : MetaTileEntities.SUBSTATION_ENERGY_OUTPUT_HATCH) {
                if (metaTileEntityEnergyHatch == null) continue;
                subItems.add((Object)metaTileEntityEnergyHatch.getStackForm());
            }
        }
    }

    @Override
    public void doExplosion(float explosionPower) {
        if (this.getController() != null) {
            this.getController().explodeMultiblock(explosionPower);
        } else {
            super.doExplosion(explosionPower);
        }
    }
}

