/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.google.common.collect.ImmutableSet;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.metatileentity.multiblock.DummyCleanroom;
import gregtech.api.metatileentity.multiblock.ICleanroomProvider;
import gregtech.api.metatileentity.multiblock.ICleanroomReceiver;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityAutoMaintenanceHatch;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityCleaningMaintenanceHatch
extends MetaTileEntityAutoMaintenanceHatch {
    protected static final Set<CleanroomType> CLEANED_TYPES = new ObjectOpenHashSet();
    private static final ICleanroomProvider DUMMY_CLEANROOM;

    public MetaTileEntityCleaningMaintenanceHatch(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityCleaningMaintenanceHatch(this.metaTileEntityId);
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        if (controllerBase instanceof ICleanroomReceiver && ((ICleanroomReceiver)((Object)controllerBase)).getCleanroom() == null) {
            ((ICleanroomReceiver)((Object)controllerBase)).setCleanroom(DUMMY_CLEANROOM);
        }
    }

    @Override
    public int getTier() {
        return 8;
    }

    @Override
    public ICubeRenderer getBaseTexture() {
        MultiblockControllerBase controller = this.getController();
        if (controller != null) {
            this.hatchTexture = controller.getBaseTexture(this);
            return this.hatchTexture;
        }
        if (this.hatchTexture != null) {
            if (this.hatchTexture != Textures.getInactiveTexture(this.hatchTexture)) {
                this.hatchTexture = Textures.getInactiveTexture(this.hatchTexture);
                return this.hatchTexture;
            }
            return this.hatchTexture;
        }
        return Textures.VOLTAGE_CASINGS[this.getTier()];
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        this.getBaseTexture().render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))));
        if (this.shouldRenderOverlay()) {
            Textures.MAINTENANCE_OVERLAY_CLEANING.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.maintenance_hatch_cleanroom_auto.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.maintenance_hatch.cleanroom_auto.tooltip.2", (Object[])new Object[0]));
        for (CleanroomType type : CLEANED_TYPES) {
            tooltip.add(String.format("  %s%s", TextFormatting.GREEN, I18n.func_135052_a((String)type.getTranslationKey(), (Object[])new Object[0])));
        }
    }

    public static void addCleanroomType(@NotNull CleanroomType type) {
        CLEANED_TYPES.add(type);
    }

    public static ImmutableSet<CleanroomType> getCleanroomTypes() {
        return ImmutableSet.copyOf(CLEANED_TYPES);
    }

    static {
        CLEANED_TYPES.add(CleanroomType.CLEANROOM);
        DUMMY_CLEANROOM = DummyCleanroom.createForTypes(CLEANED_TYPES);
    }
}

