/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.centralmonitor;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverHolder;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.items.behavior.MonitorPluginBaseBehavior;
import gregtech.api.items.behavior.ProxyHolderPluginBehavior;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityUIFactory;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.util.FacingPos;
import gregtech.api.util.GTLog;
import gregtech.client.utils.RenderUtil;
import gregtech.common.covers.CoverDigitalInterface;
import gregtech.common.gui.widget.WidgetARGB;
import gregtech.common.gui.widget.monitor.WidgetCoverList;
import gregtech.common.gui.widget.monitor.WidgetMonitorScreen;
import gregtech.common.gui.widget.monitor.WidgetPluginConfig;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityCentralMonitor;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMonitorScreen
extends MetaTileEntityMultiblockPart {
    public CoverDigitalInterface coverTMP;
    private long lastClickTime;
    private UUID lastClickUUID;
    public MonitorPluginBaseBehavior plugin;
    public FacingPos coverPos;
    public CoverDigitalInterface.MODE mode = CoverDigitalInterface.MODE.FLUID;
    public int slot = 0;
    public float scale = 1.0f;
    public int frameColor = -16711936;
    private ItemStackHandler inventory;

    public MetaTileEntityMonitorScreen(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 1);
    }

    public void setMode(FacingPos cover, CoverDigitalInterface.MODE mode) {
        CoverDigitalInterface last_cover = this.getCoverFromPosSide(this.coverPos);
        CoverDigitalInterface now_cover = this.getCoverFromPosSide(cover);
        if (this.mode == mode && (Objects.equals(cover, this.coverPos) && last_cover == null && cover == null || last_cover != null && last_cover == now_cover)) {
            return;
        }
        if (last_cover != null && this.mode != CoverDigitalInterface.MODE.PROXY) {
            last_cover.unSubProxyMode(this.mode);
        }
        if (cover != null && mode != CoverDigitalInterface.MODE.PROXY) {
            now_cover.subProxyMode(mode);
        }
        this.coverPos = cover;
        this.mode = mode;
        this.updateProxyPlugin();
        this.writeCustomData(GregtechDataCodes.UPDATE_ALL, this::writeSync);
        this.markDirty();
    }

    public void setMode(FacingPos cover) {
        this.setMode(cover, this.mode);
    }

    public void setMode(CoverDigitalInterface.MODE mode) {
        this.setMode(this.coverPos, mode);
    }

    public void setConfig(int slot, float scale, int color) {
        if ((this.scale == scale || scale < 1.0f || scale > 8.0f) && (this.slot == slot || slot < 0) && this.frameColor == color) {
            return;
        }
        this.slot = slot;
        this.scale = scale;
        this.frameColor = color;
        this.writeCustomData(GregtechDataCodes.UPDATE_ALL, this::writeSync);
        this.markDirty();
    }

    public CoverDigitalInterface getCoverFromPosSide(FacingPos posFacing) {
        Cover cover;
        if (posFacing == null) {
            return null;
        }
        CoverHolder coverHolder = null;
        IGregTechTileEntity holder = this.getHolderFromPos(posFacing.getPos());
        if (holder == null) {
            TileEntity te;
            TileEntity tileEntity = te = this.getWorld() == null ? null : this.getWorld().func_175625_s(posFacing.getPos());
            if (te instanceof IPipeTile) {
                IPipeTile pipeTile = (IPipeTile)te;
                coverHolder = pipeTile.getCoverableImplementation();
            }
        } else {
            coverHolder = holder.getMetaTileEntity();
        }
        if (coverHolder != null && (cover = coverHolder.getCoverAtSide(posFacing.getFacing())) instanceof CoverDigitalInterface) {
            CoverDigitalInterface digitalInterface = (CoverDigitalInterface)cover;
            return digitalInterface;
        }
        return null;
    }

    public IGregTechTileEntity getHolderFromPos(BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = this.getWorld() == null || pos == null ? null : this.getWorld().func_175625_s(pos);
        if (te instanceof IGregTechTileEntity && ((IGregTechTileEntity)te).isValid()) {
            return (IGregTechTileEntity)te;
        }
        return null;
    }

    public void updateCoverValid(Set<FacingPos> covers) {
        if (this.coverPos != null && !covers.contains(this.coverPos)) {
            this.setMode(null, CoverDigitalInterface.MODE.PROXY);
        }
    }

    private void writeSync(PacketBuffer buf) {
        buf.writeBoolean(this.coverPos != null);
        if (this.coverPos != null) {
            buf.func_179255_a(this.coverPos.getPos());
            buf.writeByte(this.coverPos.getFacing().func_176745_a());
        }
        buf.writeByte(this.mode.ordinal());
        buf.func_150787_b(this.slot);
        buf.writeFloat(this.scale);
        buf.func_150787_b(this.frameColor);
    }

    private void readSync(PacketBuffer buf) {
        if (buf.readBoolean()) {
            EnumFacing side;
            BlockPos pos = buf.func_179259_c();
            FacingPos pair = new FacingPos(pos, side = EnumFacing.func_82600_a((int)buf.readByte()));
            if (!pair.equals(this.coverPos)) {
                this.coverTMP = null;
                this.coverPos = pair;
            }
        } else {
            this.coverPos = null;
            this.coverTMP = null;
        }
        this.mode = CoverDigitalInterface.MODE.VALUES[buf.readByte()];
        this.slot = buf.func_150792_a();
        this.scale = buf.readFloat();
        this.frameColor = buf.func_150792_a();
        this.updateProxyPlugin();
    }

    private void updateProxyPlugin() {
        if (this.plugin instanceof ProxyHolderPluginBehavior) {
            if (this.mode == CoverDigitalInterface.MODE.PROXY && this.coverPos != null) {
                ((ProxyHolderPluginBehavior)this.plugin).onHolderPosUpdated(this.coverPos.getPos());
            } else {
                ((ProxyHolderPluginBehavior)this.plugin).onHolderPosUpdated(null);
            }
        }
    }

    public int getX() {
        MultiblockControllerBase controller = this.getController();
        if (controller != null) {
            EnumFacing spin = controller.getUpwardsFacing();
            switch (controller.getFrontFacing().func_176740_k()) {
                case Y: {
                    if (spin.func_176740_k() == EnumFacing.Axis.X) {
                        return Math.abs(this.getController().getPos().func_177952_p() - this.getPos().func_177952_p()) - 1;
                    }
                    return Math.abs(this.getController().getPos().func_177958_n() - this.getPos().func_177958_n()) - 1;
                }
                case X: {
                    if (spin.func_176740_k() == EnumFacing.Axis.Z) {
                        return Math.abs(this.getController().getPos().func_177952_p() - this.getPos().func_177952_p()) - 1;
                    }
                    return Math.abs(this.getController().getPos().func_177956_o() - this.getPos().func_177956_o()) - 1;
                }
            }
            if (spin.func_176740_k() == EnumFacing.Axis.Z) {
                return Math.abs(this.getController().getPos().func_177958_n() - this.getPos().func_177958_n()) - 1;
            }
            return Math.abs(this.getController().getPos().func_177956_o() - this.getPos().func_177956_o()) - 1;
        }
        return -1;
    }

    public int getY() {
        MultiblockControllerBase controller = this.getController();
        if (controller != null) {
            EnumFacing spin = controller.getUpwardsFacing();
            EnumFacing facing = controller.getFrontFacing();
            int height = ((MetaTileEntityCentralMonitor)this.getController()).height;
            switch (facing.func_176740_k()) {
                case Y: {
                    if (spin.func_176740_k() == EnumFacing.Axis.X) {
                        return height - Math.abs(controller.getPos().func_177958_n() - spin.func_82601_c() - this.getPos().func_177958_n()) - 1;
                    }
                    return height - Math.abs(controller.getPos().func_177952_p() - spin.func_82599_e() - this.getPos().func_177952_p()) - 1;
                }
                case X: {
                    if (spin.func_176740_k() == EnumFacing.Axis.Z) {
                        return height - Math.abs(controller.getPos().func_177956_o() + spin.func_82599_e() - this.getPos().func_177956_o()) - 1;
                    }
                    return height - Math.abs(controller.getPos().func_177952_p() + spin.func_82601_c() * facing.func_176746_e().func_82599_e() - this.getPos().func_177952_p()) - 1;
                }
            }
            if (spin.func_176740_k() == EnumFacing.Axis.Z) {
                return height - Math.abs(controller.getPos().func_177956_o() + spin.func_82599_e() - this.getPos().func_177956_o()) - 1;
            }
            return height - Math.abs(controller.getPos().func_177958_n() + spin.func_82601_c() * facing.func_176746_e().func_82601_c() - this.getPos().func_177958_n()) - 1;
        }
        return -1;
    }

    @Override
    public boolean isActive() {
        if (this.coverPos != null && this.mode != CoverDigitalInterface.MODE.PROXY) {
            CoverDigitalInterface cover;
            CoverDigitalInterface coverDigitalInterface = cover = this.coverTMP != null ? this.coverTMP : this.getCoverFromPosSide(this.coverPos);
            if (cover != null && cover.isProxy()) {
                this.coverTMP = cover;
                return true;
            }
            this.coverPos = null;
        }
        return this.plugin != null;
    }

    public void pluginDirty() {
        if (this.plugin != null) {
            this.plugin.writeToNBT(this.itemInventory.getStackInSlot(0).func_190925_c("monitor_plugin"));
        }
    }

    private void loadPlugin(MonitorPluginBaseBehavior plugin) {
        if (plugin != null && this.plugin != plugin) {
            this.plugin = plugin.createPlugin();
            this.plugin.readFromNBT(this.itemInventory.getStackInSlot(0).func_190925_c("monitor_plugin"));
            this.plugin.onMonitorValid(this, true);
        }
        this.updateProxyPlugin();
    }

    private void unloadPlugin() {
        if (this.plugin != null) {
            this.plugin.onMonitorValid(null, false);
        }
        this.plugin = null;
    }

    @Override
    public void update() {
        super.update();
        if (this.plugin != null && this.getController() != null && this.isActive()) {
            this.plugin.update();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderScreen(float partialTicks, RayTraceResult rayTraceResult) {
        if (this.getController() == null) {
            return;
        }
        EnumFacing side = this.getController().getFrontFacing();
        GlStateManager.func_179137_b((double)((double)(this.scale - 1.0f) * 0.5), (double)((double)(this.scale - 1.0f) * 0.5), (double)0.0);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
        if (this.plugin != null) {
            this.plugin.renderPlugin(partialTicks, rayTraceResult);
        }
        if (this.coverTMP != null) {
            boolean flag = true;
            if (this.checkLookingAt(rayTraceResult) != null && this.plugin == null && this.mode != CoverDigitalInterface.MODE.PROXY && this.coverTMP.renderSneakingLookAt(rayTraceResult.func_178782_a(), side, this.slot, partialTicks)) {
                flag = false;
            }
            if (this.mode == CoverDigitalInterface.MODE.PROXY) {
                return;
            }
            if (flag) {
                this.coverTMP.renderMode(this.mode, this.slot, partialTicks);
                TileEntity te = this.coverTMP.getCoveredTE();
                if (te != null) {
                    ItemStack itemStack;
                    if (te instanceof IGregTechTileEntity) {
                        itemStack = ((IGregTechTileEntity)te).getMetaTileEntity().getStackForm();
                    } else {
                        BlockPos pos = te.func_174877_v();
                        itemStack = te.func_145838_q().getPickBlock(te.func_145831_w().func_180495_p(pos), new RayTraceResult(new Vec3d(0.5, 0.5, 0.5), this.coverTMP.getCoveredFacing(), pos), te.func_145831_w(), pos, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    }
                    String name = itemStack.func_82833_r();
                    RenderUtil.renderItemOverLay(-2.6f, -2.65f, 0.003f, 0.01f, itemStack);
                    RenderUtil.renderText(0.0f, -0.21875f, 0.0f, 0.005f, -1, name, true);
                }
            }
            RenderUtil.renderRect(-0.4375f, -0.4375f, 0.875f, 0.01f, 0.003f, this.frameColor);
            RenderUtil.renderRect(-0.4375f, -0.26f, 0.875f, 0.01f, 0.003f, this.frameColor);
            RenderUtil.renderRect(-0.4375f, -0.4275f, 0.01f, 0.1675f, 0.003f, this.frameColor);
            RenderUtil.renderRect(0.4275f, -0.4275f, 0.01f, 0.1675f, 0.003f, this.frameColor);
            RenderUtil.renderRect(-0.4375f, -0.1875f, 0.875f, 0.01f, 0.003f, this.frameColor);
            RenderUtil.renderRect(-0.4375f, 0.4275f, 0.875f, 0.01f, 0.003f, this.frameColor);
            RenderUtil.renderRect(-0.4375f, -0.1775f, 0.01f, 0.605f, 0.003f, this.frameColor);
            RenderUtil.renderRect(0.4275f, -0.1775f, 0.01f, 0.605f, 0.003f, this.frameColor);
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.writeSync(buf);
        buf.func_150788_a(this.inventory.getStackInSlot(0));
        if (this.plugin != null) {
            this.plugin.writeInitialSyncData(buf);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.readSync(buf);
        try {
            ItemStack itemStack = buf.func_150791_c();
            MonitorPluginBaseBehavior behavior = MonitorPluginBaseBehavior.getBehavior(itemStack);
            if (behavior == null) {
                this.unloadPlugin();
            } else {
                this.inventory.setStackInSlot(0, itemStack);
                this.loadPlugin(behavior);
                this.plugin.receiveInitialSyncData(buf);
            }
        }
        catch (IOException e) {
            GTLog.logger.error("Could not initialize Monitor Screen from InitialSyncData buffer", (Throwable)e);
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_ALL) {
            this.readSync(buf);
        } else if (dataId == GregtechDataCodes.UPDATE_PLUGIN_DATA) {
            if (this.plugin != null) {
                this.plugin.readPluginData(buf.func_150792_a(), buf);
            }
        } else if (dataId == GregtechDataCodes.UPDATE_PLUGIN_ITEM) {
            try {
                ItemStack itemStack = buf.func_150791_c();
                MonitorPluginBaseBehavior behavior = MonitorPluginBaseBehavior.getBehavior(itemStack);
                if (behavior == null) {
                    this.unloadPlugin();
                } else {
                    this.inventory.setStackInSlot(0, itemStack);
                    this.loadPlugin(behavior);
                }
            }
            catch (IOException e) {
                GTLog.logger.error("Could not initialize Monitor Screen from CustomData buffer", (Throwable)e);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        if (this.coverPos != null) {
            data.func_74782_a("coverPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.coverPos.getPos()));
            data.func_74774_a("coverSide", (byte)this.coverPos.getFacing().func_176745_a());
        }
        data.func_74774_a("mode", (byte)this.mode.ordinal());
        data.func_74776_a("scale", this.scale);
        data.func_74768_a("color", this.frameColor);
        data.func_74768_a("slot", this.slot);
        data.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        return super.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.frameColor = data.func_74764_b("color") ? data.func_74762_e("color") : -16711936;
        this.scale = data.func_74764_b("scale") ? data.func_74760_g("scale") : 1.0f;
        this.slot = data.func_74764_b("slot") ? data.func_74762_e("slot") : 0;
        this.mode = CoverDigitalInterface.MODE.VALUES[data.func_74764_b("mode") ? (int)data.func_74771_c("mode") : 0];
        this.inventory.deserializeNBT(data.func_74775_l("Inventory"));
        if (data.func_74764_b("coverPos") && data.func_74764_b("coverSide")) {
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)data.func_74775_l("coverPos"));
            EnumFacing side = EnumFacing.func_82600_a((int)data.func_74771_c("coverSide"));
            this.coverPos = new FacingPos(pos, side);
        } else {
            this.coverPos = null;
        }
        MonitorPluginBaseBehavior behavior = MonitorPluginBaseBehavior.getBehavior(this.inventory.getStackInSlot(0));
        if (behavior == null) {
            this.unloadPlugin();
        } else {
            this.loadPlugin(behavior);
        }
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.inventory = new GTItemStackHandler(this){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                MonitorPluginBaseBehavior behavior = MonitorPluginBaseBehavior.getBehavior(stack);
                return behavior != null;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!(MetaTileEntityMonitorScreen.this.getWorld().field_72995_K || this.getStackInSlot(slot).func_190926_b() || simulate)) {
                    MetaTileEntityMonitorScreen.this.unloadPlugin();
                    MetaTileEntityMonitorScreen.this.writeCustomData(GregtechDataCodes.UPDATE_PLUGIN_ITEM, packetBuffer -> packetBuffer.func_150788_a(ItemStack.field_190927_a));
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
        this.itemInventory = this.inventory;
    }

    @Override
    public boolean shouldRenderOverlay() {
        MultiblockControllerBase controller = this.getController();
        return controller instanceof MetaTileEntityCentralMonitor && controller.isActive();
    }

    @Override
    public boolean canPlaceCoverOnSide(@NotNull EnumFacing side) {
        return this.getController() != null && this.getController().getFrontFacing() != side;
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (!this.getWorld().field_72995_K) {
            this.setMode(null, this.mode);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        CoverDigitalInterface cover;
        if ((capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) && (cover = this.getCoverFromPosSide(this.coverPos)) != null) {
            return (T)cover.getCoverableView().getCapability(capability, cover.getAttachedSide());
        }
        return null;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new MetaTileEntityMonitorScreen(this.metaTileEntityId);
    }

    @Override
    protected ModularUI createUI(final EntityPlayer entityPlayer) {
        MultiblockControllerBase controller = this.getController();
        if (controller instanceof MetaTileEntityCentralMonitor && controller.isActive()) {
            int width = 330;
            int height = 260;
            ToggleButtonWidget[] buttons = new ToggleButtonWidget[]{new ToggleButtonWidget(width - 135, 25, 20, 20, GuiTextures.BUTTON_FLUID, () -> this.mode == CoverDigitalInterface.MODE.FLUID, isPressed -> {
                if (isPressed) {
                    this.setMode(CoverDigitalInterface.MODE.FLUID);
                }
            }).setTooltipText("metaitem.cover.digital.mode.fluid", new Object[0]), new ToggleButtonWidget(width - 115, 25, 20, 20, GuiTextures.BUTTON_ITEM, () -> this.mode == CoverDigitalInterface.MODE.ITEM, isPressed -> {
                if (isPressed) {
                    this.setMode(CoverDigitalInterface.MODE.ITEM);
                }
            }).setTooltipText("metaitem.cover.digital.mode.item", new Object[0]), new ToggleButtonWidget(width - 95, 25, 20, 20, GuiTextures.BUTTON_ENERGY, () -> this.mode == CoverDigitalInterface.MODE.ENERGY, isPressed -> {
                if (isPressed) {
                    this.setMode(CoverDigitalInterface.MODE.ENERGY);
                }
            }).setTooltipText("metaitem.cover.digital.mode.energy", new Object[0]), new ToggleButtonWidget(width - 75, 25, 20, 20, GuiTextures.BUTTON_MACHINE, () -> this.mode == CoverDigitalInterface.MODE.MACHINE, isPressed -> {
                if (isPressed) {
                    this.setMode(CoverDigitalInterface.MODE.MACHINE);
                }
            }).setTooltipText("metaitem.cover.digital.mode.machine", new Object[0]), new ToggleButtonWidget(width - 35, 25, 20, 20, GuiTextures.BUTTON_INTERFACE, () -> this.mode == CoverDigitalInterface.MODE.PROXY, isPressed -> {
                if (isPressed) {
                    this.setMode(CoverDigitalInterface.MODE.PROXY);
                }
            }).setTooltipText("metaitem.cover.digital.mode.proxy", new Object[0])};
            ArrayList<CoverDigitalInterface> covers = new ArrayList<CoverDigitalInterface>();
            ((MetaTileEntityCentralMonitor)controller).getAllCovers().forEach(coverPos -> covers.add(this.getCoverFromPosSide((FacingPos)coverPos)));
            final WidgetPluginConfig pluginWidget = new WidgetPluginConfig();
            final WidgetPluginConfig mainGroup = new WidgetPluginConfig().setSize(width, height);
            mainGroup.widget(new LabelWidget(15, 55, "monitor.gui.title.scale", -1)).widget(new ClickButtonWidget(50, 50, 20, 20, "-1", data -> this.setConfig(this.slot, (float)Math.round((this.scale - (data.isShiftClick ? 1.0f : 0.1f)) * 10.0f) / 10.0f, this.frameColor))).widget(new ClickButtonWidget(130, 50, 20, 20, "+1", data -> this.setConfig(this.slot, (float)Math.round((this.scale + (data.isShiftClick ? 1.0f : 0.1f)) * 10.0f) / 10.0f, this.frameColor))).widget(new ImageWidget(70, 50, 60, 20, GuiTextures.DISPLAY)).widget(new SimpleTextWidget(100, 60, "", 0xFFFFFF, () -> Float.toString(this.scale))).widget(new LabelWidget(15, 85, "monitor.gui.title.argb", -1)).widget(new WidgetARGB(50, 80, 20, this.frameColor, color -> this.setConfig(this.slot, this.scale, (int)color))).widget(new LabelWidget(15, 110, "monitor.gui.title.slot", -1)).widget(new ClickButtonWidget(50, 105, 20, 20, "-1", data -> this.setConfig(this.slot - 1, this.scale, this.frameColor))).widget(new ClickButtonWidget(130, 105, 20, 20, "+1", data -> this.setConfig(this.slot + 1, this.scale, this.frameColor))).widget(new ImageWidget(70, 105, 60, 20, GuiTextures.DISPLAY)).widget(new SimpleTextWidget(100, 115, "", 0xFFFFFF, () -> Integer.toString(this.slot))).widget(new LabelWidget(15, 135, "monitor.gui.title.plugin", -1)).widget(new SlotWidget((IItemHandler)this.inventory, 0, 50, 130, true, true).setBackgroundTexture(GuiTextures.SLOT).setChangeListener(() -> {
                if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                    MonitorPluginBaseBehavior behavior = MonitorPluginBaseBehavior.getBehavior(this.inventory.getStackInSlot(0));
                    if (behavior == null) {
                        this.unloadPlugin();
                    } else {
                        this.loadPlugin(behavior);
                    }
                    this.writeCustomData(GregtechDataCodes.UPDATE_PLUGIN_ITEM, packetBuffer -> packetBuffer.func_150788_a(this.inventory.getStackInSlot(0)));
                }
            })).widget(new ClickButtonWidget(80, 130, 40, 20, "monitor.gui.title.config", data -> {
                if (this.plugin != null && mainGroup.isVisible()) {
                    this.plugin.customUI(pluginWidget, this.getHolder(), entityPlayer);
                    mainGroup.setVisible(false);
                }
            }){

                @Override
                protected void triggerButton() {
                    super.triggerButton();
                    if (MetaTileEntityMonitorScreen.this.plugin != null && mainGroup.isVisible()) {
                        MetaTileEntityMonitorScreen.this.plugin.customUI(pluginWidget, MetaTileEntityMonitorScreen.this.getHolder(), entityPlayer);
                        mainGroup.setVisible(false);
                    }
                }
            }).widget(new WidgetCoverList(width - 140, 50, 120, 11, covers, this.getCoverFromPosSide(this.coverPos), coverPos -> {
                if (coverPos == null) {
                    this.setMode(null, this.mode);
                } else {
                    this.setMode(new FacingPos(coverPos.getPos(), coverPos.getAttachedSide()));
                }
            })).widget(buttons[0]).widget(buttons[1]).widget(buttons[2]).widget(buttons[3]).widget(buttons[4]).bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 15, 170);
            return ModularUI.builder(GuiTextures.BOXED_BACKGROUND, width, height).widget(pluginWidget).widget(mainGroup).widget(new WidgetMonitorScreen(330, 0, 150, this)).widget(new LabelWidget(15, 13, "gregtech.machine.monitor_screen.name", -1)).widget(new ClickButtonWidget(15, 25, 40, 20, "monitor.gui.title.back", data -> {
                if (mainGroup.isVisible() && controller.isActive() && controller.isValid()) {
                    MetaTileEntityUIFactory.INSTANCE.openUI(controller.getHolder(), (EntityPlayerMP)entityPlayer);
                } else if (!mainGroup.isVisible()) {
                    pluginWidget.removePluginWidget();
                    mainGroup.setVisible(true);
                    if (this.plugin != null) {
                        this.plugin.markAsDirty();
                    }
                }
            }){

                @Override
                protected void triggerButton() {
                    super.triggerButton();
                    if (!mainGroup.isVisible()) {
                        pluginWidget.removePluginWidget();
                        mainGroup.setVisible(true);
                        if (MetaTileEntityMonitorScreen.this.plugin != null) {
                            MetaTileEntityMonitorScreen.this.plugin.markAsDirty();
                        }
                    }
                }
            }).bindCloseListener(() -> {
                if (this.plugin != null) {
                    this.plugin.markAsDirty();
                }
            }).build(this.getHolder(), entityPlayer);
        }
        return null;
    }

    public boolean onClickLogic(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, boolean isRight, double x, double y) {
        boolean flag;
        if (this.plugin != null && (flag = this.plugin.onClickLogic(playerIn, hand, facing, isRight, x, y))) {
            return true;
        }
        if (this.getWorld().field_72995_K) {
            return true;
        }
        CoverDigitalInterface cover = this.getCoverFromPosSide(this.coverPos);
        if (isRight) {
            if (cover != null && cover.isProxy() && this.mode != CoverDigitalInterface.MODE.PROXY) {
                if (playerIn.func_70093_af() && playerIn.func_184614_ca().func_190926_b() && this.plugin == null) {
                    if (0.0625 < x && x < 0.25 && 0.0625 < y && y < 0.25) {
                        this.setConfig(this.slot - 1, this.scale, this.frameColor);
                        return true;
                    }
                    if (0.75 < x && x < 0.9375 && 0.0625 < y && y < 0.25) {
                        this.setConfig(this.slot + 1, this.scale, this.frameColor);
                        return true;
                    }
                }
                if (cover.modeRightClick(playerIn, hand, this.mode, this.slot) == EnumActionResult.PASS) {
                    if (!playerIn.func_70093_af() && this.openGUIOnRightClick()) {
                        TileEntity te = cover.getCoveredTE();
                        if (te != null) {
                            BlockPos pos = te.func_174877_v();
                            IBlockState state = te.func_145831_w().func_180495_p(pos);
                            state.func_177230_c().func_180639_a(cover.getWorld(), pos, state, playerIn, hand, cover.getCoveredFacing(), 0.5f, 0.5f, 0.5f);
                        }
                        return true;
                    }
                    return false;
                }
                return true;
            }
        } else if (cover != null && cover.isProxy() && this.mode != CoverDigitalInterface.MODE.PROXY) {
            return cover.modeLeftClick(playerIn, this.mode, this.slot);
        }
        return false;
    }

    private static double[] handleRayTraceResult(RayTraceResult rayTraceResult) {
        double dX = rayTraceResult.field_178784_b.func_176740_k() == EnumFacing.Axis.X ? rayTraceResult.field_72307_f.field_72449_c - (double)rayTraceResult.func_178782_a().func_177952_p() : rayTraceResult.field_72307_f.field_72450_a - (double)rayTraceResult.func_178782_a().func_177958_n();
        double dY = rayTraceResult.field_178784_b.func_176740_k() == EnumFacing.Axis.Y ? rayTraceResult.field_72307_f.field_72449_c - (double)rayTraceResult.func_178782_a().func_177952_p() : rayTraceResult.field_72307_f.field_72448_b - (double)rayTraceResult.func_178782_a().func_177956_o();
        dX = 1.0 - dX;
        dY = 1.0 - dY;
        if (rayTraceResult.field_178784_b.func_96559_d() < 0) {
            dY = 1.0 - dY;
        }
        if (rayTraceResult.field_178784_b == EnumFacing.WEST || rayTraceResult.field_178784_b == EnumFacing.SOUTH) {
            dX = 1.0 - dX;
        } else if (rayTraceResult.field_178784_b == EnumFacing.UP) {
            dX = 1.0 - dX;
            dY = 1.0 - dY;
        }
        return new double[]{dX, dY};
    }

    private boolean handleHitResultWithScale(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, boolean isRight, CuboidRayTraceResult rayTraceResult) {
        boolean flag = false;
        if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && this.getController() != null) {
            double[] pos = MetaTileEntityMonitorScreen.handleRayTraceResult((RayTraceResult)rayTraceResult);
            MetaTileEntityMonitorScreen[][] screens = ((MetaTileEntityCentralMonitor)this.getController()).screens;
            int mX = this.getX();
            int mY = this.getY();
            int max = Math.max(mX, mY);
            for (int i = 0; i <= max && mX - i >= 0; ++i) {
                for (int j = 0; j <= max && mY - j >= 0; ++j) {
                    MetaTileEntityMonitorScreen screen = screens[mX - i][mY - j];
                    if (screen == null || !screen.isActive()) continue;
                    double xR = (pos[0] + (double)i) / (double)screen.scale;
                    double yR = (pos[1] + (double)j) / (double)screen.scale;
                    if (!(xR >= 0.0) || !(xR <= 1.0) || !(yR >= 0.0) || !(yR <= 1.0) || !screen.onClickLogic(playerIn, hand, facing, isRight, xR, yR)) continue;
                    flag = true;
                }
            }
        }
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public double[] checkLookingAt(RayTraceResult rayTraceResult) {
        if (this.getWorld() != null) {
            MetaTileEntityMonitorScreen screenHit;
            TileEntity tileEntity;
            MultiblockControllerBase controller = this.getController();
            if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && controller != null && rayTraceResult.field_178784_b == controller.getFrontFacing() && (tileEntity = this.getWorld().func_175625_s(rayTraceResult.func_178782_a())) instanceof IGregTechTileEntity && ((IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof MetaTileEntityMonitorScreen && controller == (screenHit = (MetaTileEntityMonitorScreen)((IGregTechTileEntity)tileEntity).getMetaTileEntity()).getController()) {
                int i = ((MetaTileEntityMonitorScreen)((IGregTechTileEntity)tileEntity).getMetaTileEntity()).getX() - this.getX();
                int j = ((MetaTileEntityMonitorScreen)((IGregTechTileEntity)tileEntity).getMetaTileEntity()).getY() - this.getY();
                double[] pos = MetaTileEntityMonitorScreen.handleRayTraceResult(rayTraceResult);
                if (i >= 0 && j >= 0) {
                    pos[0] = (pos[0] + (double)i) / (double)this.scale;
                    pos[1] = (pos[1] + (double)j) / (double)this.scale;
                    if (pos[0] >= 0.0 && pos[0] <= 1.0 && pos[1] >= 0.0 && pos[1] <= 1.0) {
                        return new double[]{pos[0], pos[1]};
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!(!playerIn.func_70093_af() && ToolHelper.isTool(playerIn.func_184586_b(hand), "screwdriver") || MetaTileEntities.MONITOR_SCREEN.getStackForm().func_77969_a(playerIn.func_184586_b(hand)))) {
            if (playerIn.field_70170_p.func_82737_E() - this.lastClickTime < 2L && playerIn.getPersistentID().equals(this.lastClickUUID)) {
                return true;
            }
            this.lastClickTime = playerIn.field_70170_p.func_82737_E();
            this.lastClickUUID = playerIn.getPersistentID();
            MultiblockControllerBase controller = this.getController();
            if (controller instanceof MetaTileEntityCentralMonitor && controller.isActive() && controller.getFrontFacing() == facing) {
                return this.handleHitResultWithScale(playerIn, hand, facing, true, hitResult);
            }
        }
        return false;
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af() && this.getWorld() != null && !this.getWorld().field_72995_K) {
            MetaTileEntityUIFactory.INSTANCE.openUI(this.getHolder(), (EntityPlayerMP)playerIn);
            return true;
        }
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer playerIn, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (playerIn.field_70170_p.func_82737_E() - this.lastClickTime < 2L && playerIn.getPersistentID().equals(this.lastClickUUID)) {
            return;
        }
        this.lastClickTime = playerIn.field_70170_p.func_82737_E();
        this.lastClickUUID = playerIn.getPersistentID();
        MultiblockControllerBase controller = this.getController();
        if (controller != null && controller.getFrontFacing() == facing) {
            this.handleHitResultWithScale(playerIn, null, facing, false, hitResult);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.monitor_screen.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.monitor_screen.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.monitor_screen.tooltip.3", (Object[])new Object[0]));
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of(null, (Object)-1);
    }

    @Override
    public boolean showToolUsages() {
        return false;
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }
}

