/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.IMachineHatchMultiblock;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.DummyCleanroom;
import gregtech.api.metatileentity.multiblock.ICleanroomProvider;
import gregtech.api.metatileentity.multiblock.ICleanroomReceiver;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityProcessingArray
extends RecipeMapMultiblockController
implements IMachineHatchMultiblock {
    private final int tier;
    private boolean machineChanged;

    public MetaTileEntityProcessingArray(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, null);
        this.tier = tier;
        this.recipeMapWorkable = new ProcessingArrayWorkable(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityProcessingArray(this.metaTileEntityId, this.tier);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        ((ProcessingArrayWorkable)this.recipeMapWorkable).findMachineStack();
    }

    @Override
    public int getMachineLimit() {
        return this.tier == 0 ? 16 : 64;
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "X#X", "XXX").aisle("XXX", "XSX", "XXX").where('L', MetaTileEntityProcessingArray.states(this.getCasingState())).where('S', this.selfPredicate()).where('X', MetaTileEntityProcessingArray.states(this.getCasingState()).setMinGlobalLimited(this.tier == 0 ? 11 : 4).or(this.autoAbilities(false, true, true, true, true, true, true)).or(MetaTileEntityProcessingArray.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(4)).or(MetaTileEntityProcessingArray.abilities(MultiblockAbility.MACHINE_HATCH).setExactLimit(1))).where('#', MetaTileEntityProcessingArray.air()).build();
    }

    public IBlockState getCasingState() {
        return this.tier == 0 ? MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST) : MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.HSSE_STURDY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return this.tier == 0 ? Textures.ROBUST_TUNGSTENSTEEL_CASING : Textures.STURDY_HSSE_CASING;
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        ProcessingArrayWorkable logic = (ProcessingArrayWorkable)this.recipeMapWorkable;
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.recipeMapWorkable.getEnergyContainer()).addEnergyTierLine(logic.currentMachineStack == ItemStack.field_190927_a ? -1 : logic.machineTier).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentString maxMachinesText = TextComponentUtil.stringWithColor(TextFormatting.DARK_PURPLE, Integer.toString(this.getMachineLimit()));
                maxMachinesText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.machine.machine_hatch.machines_max", maxMachinesText);
                if (logic.activeRecipeMap == null) {
                    TextComponentTranslation noneText = TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.machine.machine_hatch.machines_none", new Object[0]);
                    TextComponentTranslation bodyText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.machine.machine_hatch.machines", noneText);
                    TextComponentTranslation hoverText1 = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.machine.machine_hatch.machines_none_hover", new Object[0]);
                    tl.add(TextComponentUtil.setHover((ITextComponent)bodyText, new ITextComponent[]{hoverText1, maxMachinesText}));
                } else {
                    String key = logic.getMachineStack().func_77977_a();
                    TextComponentTranslation mapText = TextComponentUtil.translationWithColor(TextFormatting.DARK_PURPLE, key + ".name", new Object[0]);
                    mapText = TextComponentUtil.translationWithColor(TextFormatting.DARK_PURPLE, "%sx %s", logic.getParallelLimit(), mapText);
                    TextComponentTranslation bodyText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.machine.machine_hatch.machines", mapText);
                    TextComponentString voltageName = new TextComponentString(GTValues.VNF[logic.machineTier]);
                    int amps = logic.getMachineStack().func_190916_E();
                    String energyFormatted = TextFormattingUtil.formatNumbers(GTValues.V[logic.machineTier] * (long)amps);
                    TextComponentTranslation hoverText = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.machine.machine_hatch.machines_max_eut", energyFormatted, amps, voltageName);
                    tl.add(TextComponentUtil.setHover((ITextComponent)bodyText, new ITextComponent[]{hoverText, maxMachinesText}));
                }
                if (this.isActive()) {
                    tl.add(TextComponentUtil.translationWithColor(TextFormatting.DARK_RED, "gregtech.machine.machine_hatch.locked", new Object[0]));
                }
            }
        }).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected OrientedOverlayRenderer getFrontOverlay() {
        return this.tier == 0 ? Textures.PROCESSING_ARRAY_OVERLAY : Textures.ADVANCED_PROCESSING_ARRAY_OVERLAY;
    }

    @Override
    public boolean canBeDistinct() {
        return true;
    }

    @Override
    public void notifyMachineChanged() {
        this.machineChanged = true;
    }

    @Override
    public String[] getBlacklist() {
        return ConfigHolder.machines.processingArrayBlacklist;
    }

    @Override
    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_MECHANICAL;
    }

    @Override
    public SoundEvent getSound() {
        return GTSoundEvents.ARC;
    }

    @Override
    public TraceabilityPredicate autoAbilities(boolean checkEnergyIn, boolean checkMaintenance, boolean checkItemIn, boolean checkItemOut, boolean checkFluidIn, boolean checkFluidOut, boolean checkMuffler) {
        TraceabilityPredicate predicate = super.autoAbilities(checkMaintenance, checkMuffler).or(checkEnergyIn ? MetaTileEntityProcessingArray.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(4).setPreviewCount(1) : new TraceabilityPredicate());
        predicate = predicate.or(MetaTileEntityProcessingArray.abilities(MultiblockAbility.IMPORT_ITEMS).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityProcessingArray.abilities(MultiblockAbility.EXPORT_ITEMS).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityProcessingArray.abilities(MultiblockAbility.IMPORT_FLUIDS).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityProcessingArray.abilities(MultiblockAbility.EXPORT_FLUIDS).setPreviewCount(1));
        return predicate;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.parallel", (Object[])new Object[]{this.getMachineLimit()}));
    }

    @Override
    public int getItemOutputLimit() {
        ItemStack machineStack = ((ProcessingArrayWorkable)this.recipeMapWorkable).getMachineStack();
        MetaTileEntity mte = GTUtility.getMetaTileEntity(machineStack);
        return mte == null ? 0 : mte.getItemOutputLimit();
    }

    protected class ProcessingArrayWorkable
    extends MultiblockRecipeLogic {
        private static final ICleanroomProvider DUMMY_CLEANROOM = DummyCleanroom.createForAllTypes();
        ItemStack currentMachineStack;
        MetaTileEntity mte;
        private int machineTier;
        private long machineVoltage;
        private RecipeMap<?> activeRecipeMap;

        public ProcessingArrayWorkable(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
            this.currentMachineStack = ItemStack.field_190927_a;
            this.mte = null;
        }

        @Override
        public void invalidate() {
            super.invalidate();
            if (this.mte != null && this.mte instanceof ICleanroomReceiver) {
                ((ICleanroomReceiver)((Object)this.mte)).setCleanroom(null);
            }
            this.currentMachineStack = ItemStack.field_190927_a;
            this.mte = null;
            MetaTileEntityProcessingArray.this.machineChanged = true;
            this.machineTier = 0;
            this.machineVoltage = 0L;
            this.activeRecipeMap = null;
        }

        @Override
        public boolean isRecipeMapValid(@NotNull RecipeMap<?> recipeMap) {
            if (ArrayUtils.contains((Object[])((IMachineHatchMultiblock)((Object)this.metaTileEntity)).getBlacklist(), (Object)recipeMap.getUnlocalizedName())) {
                return false;
            }
            return GTUtility.isMachineValidForMachineHatch(this.currentMachineStack, ((IMachineHatchMultiblock)((Object)this.metaTileEntity)).getBlacklist());
        }

        @Override
        protected boolean shouldSearchForRecipes() {
            return this.canWorkWithMachines() && super.shouldSearchForRecipes();
        }

        public boolean canWorkWithMachines() {
            if (MetaTileEntityProcessingArray.this.machineChanged) {
                this.findMachineStack();
                MetaTileEntityProcessingArray.this.machineChanged = false;
                this.previousRecipe = null;
                if (MetaTileEntityProcessingArray.this.isDistinct()) {
                    this.invalidatedInputList.clear();
                } else {
                    this.invalidInputsForRecipes = false;
                }
            }
            return !this.currentMachineStack.func_190926_b() && this.activeRecipeMap != null;
        }

        @Override
        @Nullable
        public RecipeMap<?> getRecipeMap() {
            return this.activeRecipeMap;
        }

        public void findMachineStack() {
            RecipeMapMultiblockController controller = (RecipeMapMultiblockController)this.metaTileEntity;
            ItemStack machine = controller.getAbilities(MultiblockAbility.MACHINE_HATCH).get(0).getStackInSlot(0);
            this.mte = GTUtility.getMetaTileEntity(machine);
            if (this.mte == null) {
                this.activeRecipeMap = null;
            } else {
                this.activeRecipeMap = this.mte.getRecipeMap();
                MetaTileEntityHolder holder = new MetaTileEntityHolder();
                this.mte = holder.setMetaTileEntity(this.mte);
                holder.func_145834_a(this.metaTileEntity.getWorld());
                MetaTileEntity metaTileEntity = this.mte;
                if (metaTileEntity instanceof ICleanroomReceiver) {
                    ICleanroomReceiver receiver = (ICleanroomReceiver)((Object)metaTileEntity);
                    if (ConfigHolder.machines.cleanMultiblocks) {
                        receiver.setCleanroom(DUMMY_CLEANROOM);
                    } else {
                        ICleanroomProvider provider = controller.getCleanroom();
                        if (provider != null) {
                            receiver.setCleanroom(provider);
                        }
                    }
                }
            }
            this.machineTier = this.mte instanceof ITieredMetaTileEntity ? ((ITieredMetaTileEntity)((Object)this.mte)).getTier() : 0;
            this.machineVoltage = GTValues.V[this.machineTier];
            this.currentMachineStack = machine;
        }

        @Override
        public boolean checkRecipe(@NotNull Recipe recipe) {
            if (this.mte == null) {
                return false;
            }
            AbstractRecipeLogic arl = this.mte.getRecipeLogic();
            if (arl == null) {
                return false;
            }
            return arl.checkRecipe(recipe) && super.checkRecipe(recipe);
        }

        @Override
        protected int getOverclockForTier(long voltage) {
            return super.getOverclockForTier(Math.min(this.machineVoltage, this.getMaximumOverclockVoltage()));
        }

        @Override
        public int getParallelLimit() {
            return this.currentMachineStack == null || this.currentMachineStack.func_190926_b() ? MetaTileEntityProcessingArray.this.getMachineLimit() : Math.min(this.currentMachineStack.func_190916_E(), MetaTileEntityProcessingArray.this.getMachineLimit());
        }

        @Override
        protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
            return super.findRecipe(Math.min(super.getMaxVoltage(), this.machineVoltage), inputs, fluidInputs);
        }

        @Override
        public long getMaxVoltage() {
            return super.getMaximumOverclockVoltage();
        }

        @Override
        protected int getNumberOfOCs(int recipeEUt) {
            if (!this.isAllowOverclocking()) {
                return 0;
            }
            int recipeTier = Math.max(0, GTUtility.getTierByVoltage(recipeEUt / Math.max(1, this.parallelRecipesPerformed)));
            int maximumTier = Math.min(this.machineTier, GTUtility.getTierByVoltage(this.getMaxVoltage()));
            int numberOfOCs = maximumTier - recipeTier;
            if (recipeTier == 0) {
                --numberOfOCs;
            }
            return numberOfOCs;
        }

        private ItemStack getMachineStack() {
            return this.currentMachineStack;
        }
    }
}

