/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.client.utils.PipelineUtil;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityTransformer
extends TieredMetaTileEntity {
    private final int[] highAmperages;
    private boolean isTransformUp;
    private int ampIndex;

    public MetaTileEntityTransformer(ResourceLocation metaTileEntityId, int tier, int ... highAmperages) {
        super(metaTileEntityId, tier);
        this.highAmperages = highAmperages == null || highAmperages.length == 0 ? new int[]{1} : highAmperages;
        this.ampIndex = this.highAmperages.length - 1;
        this.reinitializeEnergyContainer();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityTransformer(this.metaTileEntityId, this.getTier(), this.highAmperages);
    }

    public boolean hasMultipleAmperages() {
        return this.highAmperages != null && this.highAmperages.length > 1;
    }

    public int getCurrentHighAmperage() {
        return this.highAmperages != null ? this.highAmperages[this.ampIndex] : 4;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("Inverted", this.isTransformUp);
        if (this.hasMultipleAmperages()) {
            data.func_74768_a("ampIndex", this.ampIndex);
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isTransformUp = data.func_74767_n("Inverted");
        if (this.hasMultipleAmperages()) {
            this.ampIndex = data.func_74762_e("ampIndex");
        }
        this.reinitializeEnergyContainer();
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isTransformUp);
        if (this.hasMultipleAmperages()) {
            buf.writeInt(this.ampIndex);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isTransformUp = buf.readBoolean();
        if (this.hasMultipleAmperages()) {
            this.ampIndex = buf.readInt();
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.SYNC_TILE_MODE) {
            this.isTransformUp = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.AMP_INDEX) {
            this.ampIndex = buf.readInt();
            this.scheduleRenderUpdate();
        }
    }

    public boolean isInverted() {
        return this.isTransformUp;
    }

    public void setTransformUp(boolean inverted) {
        this.isTransformUp = inverted;
        if (!this.getWorld().field_72995_K) {
            this.reinitializeEnergyContainer();
            this.writeCustomData(GregtechDataCodes.SYNC_TILE_MODE, b -> b.writeBoolean(this.isTransformUp));
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    protected void incrementAmpIndex() {
        if (this.hasMultipleAmperages()) {
            ++this.ampIndex;
            if (this.ampIndex >= this.highAmperages.length) {
                this.ampIndex = 0;
            }
            if (!this.getWorld().field_72995_K) {
                this.reinitializeEnergyContainer();
                this.writeCustomData(GregtechDataCodes.AMP_INDEX, b -> b.writeInt(this.ampIndex));
                this.notifyBlockUpdate();
                this.markDirty();
            }
        }
    }

    @Override
    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        int highAmperage = this.getCurrentHighAmperage();
        int lowAmperage = highAmperage * 4;
        if (this.isTransformUp) {
            this.energyContainer = new EnergyContainerHandler(this, tierVoltage * 8L * (long)lowAmperage, tierVoltage, lowAmperage, tierVoltage * 4L, highAmperage);
            ((EnergyContainerHandler)this.energyContainer).setSideInputCondition(s -> s != this.getFrontFacing());
            ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s == this.getFrontFacing());
        } else {
            this.energyContainer = new EnergyContainerHandler(this, tierVoltage * 8L * (long)lowAmperage, tierVoltage * 4L, highAmperage, tierVoltage, lowAmperage);
            ((EnergyContainerHandler)this.energyContainer).setSideInputCondition(s -> s == this.getFrontFacing());
            ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s != this.getFrontFacing());
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        SimpleOverlayRenderer frontFaceTexture;
        SimpleOverlayRenderer otherFaceTexture;
        super.renderMetaTileEntity(renderState, translation, pipeline);
        switch (this.getCurrentHighAmperage()) {
            case 1: {
                otherFaceTexture = this.isTransformUp ? Textures.ENERGY_IN : Textures.ENERGY_OUT;
                frontFaceTexture = this.isTransformUp ? Textures.ENERGY_OUT_MULTI : Textures.ENERGY_IN_MULTI;
                break;
            }
            case 2: {
                otherFaceTexture = this.isTransformUp ? Textures.ENERGY_IN_MULTI : Textures.ENERGY_OUT_MULTI;
                frontFaceTexture = this.isTransformUp ? Textures.ENERGY_OUT_HI : Textures.ENERGY_IN_HI;
                break;
            }
            case 4: {
                otherFaceTexture = this.isTransformUp ? Textures.ENERGY_IN_HI : Textures.ENERGY_OUT_HI;
                frontFaceTexture = this.isTransformUp ? Textures.ENERGY_OUT_ULTRA : Textures.ENERGY_IN_ULTRA;
                break;
            }
            default: {
                otherFaceTexture = this.isTransformUp ? Textures.ENERGY_IN_ULTRA : Textures.ENERGY_OUT_ULTRA;
                frontFaceTexture = this.isTransformUp ? Textures.ENERGY_OUT_MAX : Textures.ENERGY_IN_MAX;
            }
        }
        frontFaceTexture.renderSided(this.frontFacing, renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier() + 1]));
        Arrays.stream(EnumFacing.values()).filter(f -> f != this.frontFacing).forEach(f -> otherFaceTexture.renderSided((EnumFacing)f, renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()])));
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    @Override
    public boolean onSoftMalletClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.getWorld().field_72995_K) {
            this.scheduleRenderUpdate();
            return true;
        }
        if (this.isTransformUp) {
            this.setTransformUp(false);
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.transformer.message_transform_down", new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
        } else {
            this.setTransformUp(true);
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.transformer.message_transform_up", new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
        }
        return true;
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.hasMultipleAmperages()) {
            if (this.getWorld().field_72995_K) {
                this.scheduleRenderUpdate();
                return true;
            }
            this.incrementAmpIndex();
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.transformer_adjustable.message_adjust", new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
            return true;
        }
        return false;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        String lowerTierName = GTValues.VNF[this.getTier()];
        String higherTierName = GTValues.VNF[this.getTier() + 1];
        long lowerVoltage = this.energyContainer.getOutputVoltage();
        long higherVoltage = this.energyContainer.getInputVoltage();
        long lowerAmperage = this.energyContainer.getInputAmperage();
        long higherAmperage = this.energyContainer.getOutputAmperage();
        if (!this.hasMultipleAmperages() && this.highAmperages[0] == 1) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.description", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.higher_amp.description", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_tool_usage", (Object[])new Object[0]));
        if (this.hasMultipleAmperages()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer_adjustable.tooltip_tool_usage", (Object[])new Object[]{higherAmperage}));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_transform_down", (Object[])new Object[]{lowerAmperage, higherVoltage, higherTierName, higherAmperage, lowerVoltage, lowerTierName}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_transform_up", (Object[])new Object[]{higherAmperage, lowerVoltage, lowerTierName, lowerAmperage, higherVoltage, higherTierName}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        if (this.hasMultipleAmperages()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.toggle_mode_covers", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.toggle_mode", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        if (this == MetaTileEntities.TRANSFORMER[0]) {
            for (MetaTileEntityTransformer transformer : MetaTileEntities.TRANSFORMER) {
                if (transformer == null) continue;
                subItems.add((Object)transformer.getStackForm());
            }
            for (MetaTileEntityTransformer transformer : MetaTileEntities.HI_AMP_TRANSFORMER) {
                if (transformer == null) continue;
                subItems.add((Object)transformer.getStackForm());
            }
            for (MetaTileEntityTransformer transformer : MetaTileEntities.POWER_TRANSFORMER) {
                if (transformer == null) continue;
                subItems.add((Object)transformer.getStackForm());
            }
        }
    }
}

