/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.tool;

import gregtech.api.damagesources.DamageSources;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDamageBehavior
implements IToolBehavior {
    private final List<Function<EntityLivingBase, Float>> shouldDoBonusList = new ArrayList<Function<EntityLivingBase, Float>>();
    private final String mobType;

    public EntityDamageBehavior(float bonus, Class<?> ... entities) {
        this(null, bonus, entities);
    }

    public EntityDamageBehavior(Map<Class<?>, Float> entities) {
        this(null, entities);
    }

    public EntityDamageBehavior(String mobType, float bonus, Class<?> ... entities) {
        this.mobType = mobType;
        for (Class<?> entity : entities) {
            this.shouldDoBonusList.add(e -> Float.valueOf(entity.isAssignableFrom(e.getClass()) ? bonus : 0.0f));
        }
    }

    public EntityDamageBehavior(String mobType, Map<Class<?>, Float> entities) {
        this.mobType = mobType;
        for (Map.Entry<Class<?>, Float> entry : entities.entrySet()) {
            Class<?> entity = entry.getKey();
            float bonus = entry.getValue().floatValue();
            this.shouldDoBonusList.add(e -> Float.valueOf(entity.isAssignableFrom(e.getClass()) ? bonus : 0.0f));
        }
    }

    @Override
    public void hitEntity(@NotNull ItemStack stack, @NotNull EntityLivingBase target, @NotNull EntityLivingBase attacker) {
        float damageBonus = this.shouldDoBonusList.stream().map(func -> (Float)func.apply(target)).filter(f -> f.floatValue() > 0.0f).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
        if (damageBonus != 0.0f) {
            DamageSource source = attacker instanceof EntityPlayer ? DamageSources.getPlayerDamage((EntityPlayer)attacker) : DamageSources.getMobDamage(attacker);
            target.func_70097_a(source, damageBonus);
        }
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        if (this.mobType != null && !this.mobType.isEmpty()) {
            tooltip.add(I18n.func_135052_a((String)"item.gt.tool.behavior.damage_boost", (Object[])new Object[]{I18n.func_135052_a((String)("item.gt.tool.behavior.damage_boost_" + this.mobType), (Object[])new Object[0])}));
        }
    }
}

