/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.Mods;
import gregtech.integration.baubles.BaublesModule;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ItemMagnetBehavior
implements IItemBehaviour {
    private final int range;
    private final long energyDraw;

    public ItemMagnetBehavior(int range) {
        this.range = range;
        this.energyDraw = GTValues.V[range > 8 ? 3 : 1];
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, @NotNull EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && player.func_70093_af()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(ItemMagnetBehavior.toggleActive(player.func_184586_b(hand)) ? "behavior.item_magnet.enabled" : "behavior.item_magnet.disabled", new Object[0]), true);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    private static boolean isActive(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        if (tag.func_74764_b("IsActive")) {
            return tag.func_74767_n("IsActive");
        }
        return false;
    }

    private static boolean toggleActive(ItemStack stack) {
        boolean isActive = ItemMagnetBehavior.isActive(stack);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("IsActive", !isActive);
        return !isActive;
    }

    @Override
    public void onUpdate(ItemStack stack, Entity entity) {
        if (!entity.func_70093_af() && entity.field_70173_aa % 10 == 0 && ItemMagnetBehavior.isActive(stack) && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            World world = entity.func_130014_f_();
            if (!ItemMagnetBehavior.drainEnergy(true, stack, this.energyDraw)) {
                return;
            }
            List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).func_72314_b((double)this.range, (double)this.range, (double)this.range));
            boolean didMoveEntity = false;
            for (EntityItem itemEntity : items) {
                EntityPlayer closest;
                NBTTagCompound itemTag;
                if (itemEntity.field_70128_L || (itemTag = itemEntity.getEntityData()) != null && itemTag.func_74764_b("PreventRemoteMovement") || itemEntity.func_145800_j() != null && itemEntity.func_145800_j().equals(entity.func_70005_c_()) && itemEntity.field_145804_b > 0 || (closest = world.func_72890_a((Entity)itemEntity, 4.0)) != null && closest != entity || world.field_72995_K) continue;
                if (itemEntity.field_145804_b > 0) {
                    itemEntity.field_145804_b = 0;
                }
                itemEntity.field_70179_y = 0.0;
                itemEntity.field_70181_x = 0.0;
                itemEntity.field_70159_w = 0.0;
                itemEntity.func_70107_b(entity.field_70165_t - 0.2 + world.field_73012_v.nextDouble() * 0.4, entity.field_70163_u - 0.6, entity.field_70161_v - 0.2 + world.field_73012_v.nextDouble() * 0.4);
                didMoveEntity = true;
            }
            if (didMoveEntity) {
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 2.0f));
            }
            List xp = world.func_72872_a(EntityXPOrb.class, new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).func_72314_b(4.0, 4.0, 4.0));
            for (EntityXPOrb orb : xp) {
                if (world.field_72995_K || orb.field_70128_L || orb.field_70532_c != 0 || MinecraftForge.EVENT_BUS.post((Event)new PlayerPickupXpEvent(player, orb))) continue;
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
                player.func_71001_a((Entity)orb, 1);
                player.func_71023_q(orb.field_70530_e);
                orb.func_70106_y();
                didMoveEntity = true;
            }
            if (didMoveEntity) {
                ItemMagnetBehavior.drainEnergy(false, stack, this.energyDraw);
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(@NotNull ItemTossEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        InventoryPlayer inventory = event.getPlayer().field_71071_by;
        if (Mods.Baubles.isModLoaded()) {
            inventory = BaublesModule.getBaublesWrappedInventory(event.getPlayer());
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (!this.isMagnet(stackInSlot) || !ItemMagnetBehavior.isActive(stackInSlot)) continue;
            event.getEntityItem().func_174867_a(60);
            return;
        }
    }

    private boolean isMagnet(@NotNull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof MetaItem) {
            MetaItem metaItem = (MetaItem)item;
            for (IItemBehaviour behavior : metaItem.getBehaviours(stack)) {
                if (!(behavior instanceof ItemMagnetBehavior)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean drainEnergy(boolean simulate, @NotNull ItemStack stack, long amount) {
        IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(amount, Integer.MAX_VALUE, true, false, simulate) >= amount;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        IItemBehaviour.super.addInformation(itemStack, lines);
        lines.add(I18n.func_135052_a((String)(ItemMagnetBehavior.isActive(itemStack) ? "behavior.item_magnet.enabled" : "behavior.item_magnet.disabled"), (Object[])new Object[0]));
    }
}

