/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GregTechAPI;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemColorProvider;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.IItemNameProvider;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.LocalizationUtils;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMaterialPartBehavior
implements IItemBehaviour,
IItemDurabilityManager,
IItemColorProvider,
IItemNameProvider {
    protected static NBTTagCompound getPartStatsTag(ItemStack itemStack) {
        return itemStack.func_179543_a("GT.PartStats");
    }

    protected static NBTTagCompound getOrCreatePartStatsTag(ItemStack itemStack) {
        return itemStack.func_190925_c("GT.PartStats");
    }

    public static Material getPartMaterial(ItemStack itemStack) {
        NBTTagCompound compound = AbstractMaterialPartBehavior.getPartStatsTag(itemStack);
        Material defaultMaterial = Materials.Neutronium;
        if (compound == null || !compound.func_150297_b("Material", 8)) {
            return defaultMaterial;
        }
        String materialName = compound.func_74779_i("Material");
        Material material = GregTechAPI.materialManager.getMaterial(materialName);
        if (material == null || !material.hasProperty(PropertyKey.INGOT)) {
            return defaultMaterial;
        }
        return material;
    }

    public static void setPartMaterial(ItemStack itemStack, @NotNull Material material) {
        if (!material.hasProperty(PropertyKey.INGOT)) {
            throw new IllegalArgumentException("Part material must have an Ingot!");
        }
        NBTTagCompound compound = AbstractMaterialPartBehavior.getOrCreatePartStatsTag(itemStack);
        compound.func_74778_a("Material", material.getRegistryName());
    }

    public abstract int getPartMaxDurability(ItemStack var1);

    public static int getPartDamage(ItemStack itemStack) {
        NBTTagCompound compound = AbstractMaterialPartBehavior.getPartStatsTag(itemStack);
        if (compound == null || !compound.func_150297_b("Damage", 99)) {
            return 0;
        }
        return compound.func_74762_e("Damage");
    }

    public void setPartDamage(ItemStack itemStack, int damage) {
        NBTTagCompound compound = AbstractMaterialPartBehavior.getOrCreatePartStatsTag(itemStack);
        compound.func_74768_a("Damage", Math.min(this.getPartMaxDurability(itemStack), damage));
    }

    @Override
    public String getItemStackDisplayName(ItemStack itemStack, String unlocalizedName) {
        Material material = AbstractMaterialPartBehavior.getPartMaterial(itemStack);
        return LocalizationUtils.format(unlocalizedName, material.getLocalizedName());
    }

    @Override
    public void addInformation(ItemStack stack, List<String> lines) {
        Material material = AbstractMaterialPartBehavior.getPartMaterial(stack);
        int maxDurability = this.getPartMaxDurability(stack);
        int damage = AbstractMaterialPartBehavior.getPartDamage(stack);
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.durability", (Object[])new Object[]{maxDurability - damage, maxDurability}));
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.primary_material", (Object[])new Object[]{material.getLocalizedName()}));
    }

    @Override
    public int getItemStackColor(ItemStack itemStack, int tintIndex) {
        Material material = AbstractMaterialPartBehavior.getPartMaterial(itemStack);
        return material.getMaterialRGB();
    }

    @Override
    public double getDurabilityForDisplay(ItemStack itemStack) {
        int maxDurability = this.getPartMaxDurability(itemStack);
        return (double)(maxDurability - AbstractMaterialPartBehavior.getPartDamage(itemStack)) / (double)maxDurability;
    }
}

