/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.armor.ArmorLogicSuite;
import gregtech.api.util.GTUtility;
import gregtech.api.util.input.KeyBind;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class NightvisionGoggles
extends ArmorLogicSuite {
    public NightvisionGoggles(int energyPerUse, long capacity, int voltageTier, EntityEquipmentSlot slot) {
        super(energyPerUse, capacity, voltageTier, slot);
    }

    @Override
    public void onArmorTick(World world, @NotNull EntityPlayer player, @NotNull ItemStack itemStack) {
        IElectricItem item = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item == null) {
            return;
        }
        NBTTagCompound nbtData = GTUtility.getOrCreateNbtCompound(itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        if (!player.func_184582_a(EntityEquipmentSlot.HEAD).func_77969_a(itemStack)) {
            NightvisionGoggles.disableNightVision(world, player, false);
        }
        if (this.SLOT == EntityEquipmentSlot.HEAD) {
            boolean nightvision = nbtData.func_74767_n("Nightvision");
            if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
                toggleTimer = 5;
                if (!nightvision && item.getCharge() >= (long)this.energyPerUse) {
                    nightvision = true;
                    if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.message.nightvision.enabled", new Object[0]), true);
                    }
                } else if (nightvision) {
                    nightvision = false;
                    NightvisionGoggles.disableNightVision(world, player, true);
                } else if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.message.nightvision.error", new Object[0]), true);
                }
                if (!world.field_72995_K) {
                    nbtData.func_74757_a("Nightvision", nightvision);
                }
            }
            if (nightvision && !world.field_72995_K && item.getCharge() >= (long)this.energyPerUse) {
                player.func_184589_d(MobEffects.field_76440_q);
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 999999, 0, true, false));
                item.discharge(this.energyPerUse, this.tier, true, false, false);
            }
            if (toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
            }
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        player.field_71069_bz.func_75142_b();
    }

    public static void disableNightVision(@NotNull World world, EntityPlayer player, boolean sendMsg) {
        if (!world.field_72995_K) {
            player.func_184589_d(MobEffects.field_76439_r);
            if (sendMsg) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.message.nightvision.disabled", new Object[0]), true);
            }
        }
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "gregtech:textures/armor/nightvision_goggles.png";
    }

    @Override
    public void addInfo(ItemStack itemStack, List<String> lines) {
        super.addInfo(itemStack, lines);
        if (this.SLOT == EntityEquipmentSlot.HEAD) {
            NBTTagCompound nbtData = GTUtility.getOrCreateNbtCompound(itemStack);
            boolean nv = nbtData.func_74767_n("Nightvision");
            if (nv) {
                lines.add(I18n.func_135052_a((String)"metaarmor.message.nightvision.enabled", (Object[])new Object[0]));
            } else {
                lines.add(I18n.func_135052_a((String)"metaarmor.message.nightvision.disabled", (Object[])new Object[0]));
            }
        }
    }
}

