/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng.slot;

import appeng.api.storage.data.IAEStack;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.util.Position;
import gregtech.common.gui.widget.appeng.AEConfigWidget;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.IConfigurableSlot;
import net.minecraft.network.PacketBuffer;

public class AmountSetSlot<T extends IAEStack<T>>
extends Widget {
    private int index = -1;
    private final TextFieldWidget2 amountText;
    private final AEConfigWidget<T> parentWidget;

    public AmountSetSlot(int x, int y, AEConfigWidget<T> widget) {
        super(x, y, 80, 30);
        this.parentWidget = widget;
        this.amountText = new TextFieldWidget2(x + 3, y + 14, 60, 15, this::getAmountStr, this::setNewAmount).setNumbersOnly(0, Integer.MAX_VALUE).setMaxLength(10);
    }

    public void setSlotIndex(int slotIndex) {
        this.index = slotIndex;
        this.writeClientAction(0, buf -> buf.func_150787_b(this.index));
    }

    public TextFieldWidget2 getText() {
        return this.amountText;
    }

    public String getAmountStr() {
        if (this.index < 0) {
            return "0";
        }
        IConfigurableSlot<T> slot = this.parentWidget.getConfig(this.index);
        if (slot.getConfig() != null) {
            return String.valueOf(((IAEStack)slot.getConfig()).getStackSize());
        }
        return "0";
    }

    public void setNewAmount(String amount) {
        try {
            long newAmount = Long.parseLong(amount);
            this.writeClientAction(1, buf -> buf.func_179254_b(newAmount));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 0) {
            this.index = buffer.func_150792_a();
        } else if (id == 1) {
            if (this.index < 0) {
                return;
            }
            IConfigurableSlot<T> slot = this.parentWidget.getConfig(this.index);
            long newAmt = buffer.func_179260_f();
            if (newAmt > 0L && slot.getConfig() != null) {
                ((IAEStack)slot.getConfig()).setStackSize(newAmt);
            }
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        Position position = this.getPosition();
        GuiTextures.BACKGROUND.draw(position.x, position.y, 80, 30);
        AmountSetSlot.drawStringSized("Amount", position.x + 3, position.y + 3, 0x404040, false, 1.0f, false);
        GuiTextures.DISPLAY.draw(position.x + 3, position.y + 11, 65, 14);
    }
}

