/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng;

import appeng.api.storage.data.IAEItemStack;
import gregtech.common.gui.widget.appeng.AEConfigWidget;
import gregtech.common.gui.widget.appeng.slot.AEItemConfigSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEItemList;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEItemSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.IConfigurableSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedItemStack;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class AEItemConfigWidget
extends AEConfigWidget<IAEItemStack> {
    final ExportOnlyAEItemList itemList;

    public AEItemConfigWidget(int x, int y, ExportOnlyAEItemList itemList) {
        super(x, y, itemList.getInventory(), itemList.isStocking());
        this.itemList = itemList;
    }

    @Override
    void init() {
        int size = (int)Math.sqrt(this.config.length);
        this.displayList = new IConfigurableSlot[this.config.length];
        this.cached = new IConfigurableSlot[this.config.length];
        for (int h = 0; h < size; ++h) {
            for (int w = 0; w < size; ++w) {
                int index = h * size + w;
                this.displayList[index] = new ExportOnlyAEItemSlot();
                this.cached[index] = new ExportOnlyAEItemSlot();
                this.addWidget(new AEItemConfigSlot(w * 18, h * 18, this, index));
            }
        }
    }

    public boolean hasStackInConfig(ItemStack stack) {
        return this.itemList.hasStackInConfig(stack, true);
    }

    public boolean isAutoPull() {
        return this.itemList.isAutoPull();
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1000) {
            int size = buffer.func_150792_a();
            for (int i = 0; i < size; ++i) {
                int index = buffer.func_150792_a();
                IConfigurableSlot slot = this.displayList[index];
                if (buffer.readBoolean()) {
                    slot.setConfig(WrappedItemStack.fromPacket((ByteBuf)buffer));
                } else {
                    slot.setConfig(null);
                }
                if (buffer.readBoolean()) {
                    slot.setStock(WrappedItemStack.fromPacket((ByteBuf)buffer));
                    continue;
                }
                slot.setStock(null);
            }
        }
    }
}

