/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng;

import appeng.api.storage.data.IAEFluidStack;
import gregtech.common.gui.widget.appeng.AEConfigWidget;
import gregtech.common.gui.widget.appeng.slot.AEFluidConfigSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEFluidList;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEFluidSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.IConfigurableSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedFluidStack;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;

public class AEFluidConfigWidget
extends AEConfigWidget<IAEFluidStack> {
    final ExportOnlyAEFluidList fluidList;

    public AEFluidConfigWidget(int x, int y, ExportOnlyAEFluidList fluidList) {
        super(x, y, fluidList.getInventory(), fluidList.isStocking());
        this.fluidList = fluidList;
    }

    @Override
    void init() {
        int size = (int)Math.sqrt(this.config.length);
        this.displayList = new IConfigurableSlot[this.config.length];
        this.cached = new IConfigurableSlot[this.config.length];
        for (int h = 0; h < size; ++h) {
            for (int w = 0; w < size; ++w) {
                int index = h * size + w;
                this.displayList[index] = new ExportOnlyAEFluidSlot();
                this.cached[index] = new ExportOnlyAEFluidSlot();
                this.addWidget(new AEFluidConfigSlot(w * 18, h * 18, this, index));
            }
        }
    }

    public boolean hasStackInConfig(FluidStack stack) {
        return this.fluidList.hasStackInConfig(stack, true);
    }

    public boolean isAutoPull() {
        return this.fluidList.isAutoPull();
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1000) {
            int size = buffer.func_150792_a();
            for (int i = 0; i < size; ++i) {
                int index = buffer.func_150792_a();
                IConfigurableSlot slot = this.displayList[index];
                if (buffer.readBoolean()) {
                    slot.setConfig(WrappedFluidStack.fromPacket((ByteBuf)buffer));
                } else {
                    slot.setConfig(null);
                }
                if (buffer.readBoolean()) {
                    slot.setStock(WrappedFluidStack.fromPacket((ByteBuf)buffer));
                    continue;
                }
                slot.setStock(null);
            }
        }
    }
}

