/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget;

import gregtech.api.gui.widgets.TextFieldWidget2;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class HighlightedTextField
extends TextFieldWidget2 {
    @Nullable
    private Consumer<TextHighlighter> highlightRule;
    @Nullable
    private TextHighlighter formatResult;

    public HighlightedTextField(int x, int y, int width, int height, Supplier<String> supplier, Consumer<String> setter) {
        super(x, y, width, height, supplier, setter);
    }

    public HighlightedTextField setHighlightRule(Consumer<TextHighlighter> highlightRule) {
        this.highlightRule = highlightRule;
        return this;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.formatResult = null;
    }

    @Override
    protected String getRenderText() {
        if (this.formatResult == null) {
            if (this.highlightRule == null) {
                return this.getText();
            }
            TextHighlighter highlighter = new TextHighlighter(this.getText());
            this.highlightRule.accept(highlighter);
            this.formatResult = highlighter;
            return highlighter.getFormattedText();
        }
        return this.formatResult.getFormattedText();
    }

    @Override
    protected int toOriginalTextIndex(int renderTextIndex) {
        return this.formatResult != null ? this.formatResult.toOriginalTextIndex(renderTextIndex) : renderTextIndex;
    }

    @Override
    protected int toRenderTextIndex(int originalTextIndex) {
        return this.formatResult != null ? this.formatResult.toFormattedTextIndex(originalTextIndex) : originalTextIndex;
    }

    public static final class TextHighlighter {
        private final String originalText;
        private final StringBuilder formattedTextBuilder;
        private final IntList formatOriginalIndices = new IntArrayList();
        @Nullable
        private String formattedTextCache;

        public TextHighlighter(String originalText) {
            this.originalText = originalText;
            this.formattedTextBuilder = new StringBuilder(originalText);
        }

        public String getOriginalText() {
            return this.originalText;
        }

        public String getFormattedText() {
            if (this.formattedTextCache == null) {
                this.formattedTextCache = this.formattedTextBuilder.toString();
                return this.formattedTextCache;
            }
            return this.formattedTextCache;
        }

        public int toFormattedTextIndex(int originalTextIndex) {
            int i;
            for (i = 0; i < this.formatOriginalIndices.size() && this.formatOriginalIndices.getInt(i) <= originalTextIndex; ++i) {
            }
            return originalTextIndex + i * 2;
        }

        public int toOriginalTextIndex(int formattedTextIndex) {
            int i;
            for (i = 0; i < this.formatOriginalIndices.size() && this.formatOriginalIndices.getInt(i) + i * 2 < formattedTextIndex; ++i) {
            }
            return formattedTextIndex - i * 2;
        }

        public void format(int index, TextFormatting format) {
            if (index < 0) {
                index = 0;
            } else if (index > this.originalText.length()) {
                return;
            }
            this.formattedTextBuilder.insert(this.toFormattedTextIndex(index), format.toString());
            this.formattedTextCache = null;
            for (int i = 0; i < this.formatOriginalIndices.size(); ++i) {
                if (this.formatOriginalIndices.getInt(i) <= index) continue;
                this.formatOriginalIndices.add(i, index);
                return;
            }
            this.formatOriginalIndices.add(index);
        }
    }
}

