/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.impl;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.FakeModularGuiContainer;
import gregtech.common.items.behaviors.monitorplugin.FakeGuiPluginBehavior;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;

public class FakeModularUIPluginContainer
extends FakeModularGuiContainer {
    protected int windowId;
    private final FakeGuiPluginBehavior behavior;
    public int syncId;

    public FakeModularUIPluginContainer(ModularUI modularUI, FakeGuiPluginBehavior pluginBehavior) {
        super(modularUI);
        this.behavior = pluginBehavior;
    }

    @Override
    public boolean detectSyncedPacket(PacketBuffer buffer) {
        int syncId = buffer.func_150792_a();
        int windowId = buffer.func_150792_a();
        return syncId == this.syncId && windowId == this.windowId;
    }

    @Override
    public void detectAndSendChanges() {
        ArrayList<Tuple> toUpdate = new ArrayList<Tuple>();
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            ItemStack real = ((Slot)this.inventorySlots.get(i)).func_75211_c();
            ItemStack fake = (ItemStack)this.inventoryItemStacks.get(i);
            if (ItemStack.func_77989_b((ItemStack)fake, (ItemStack)real)) continue;
            boolean clientStackChanged = !ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)fake, (ItemStack)real);
            fake = real.func_190926_b() ? ItemStack.field_190927_a : real.func_77946_l();
            this.inventoryItemStacks.set(i, (Object)fake);
            if (!clientStackChanged) continue;
            toUpdate.add(new Tuple((Object)i, (Object)fake));
        }
        if (toUpdate.size() > 0 && this.behavior != null) {
            this.behavior.writePluginData(GregtechDataCodes.UPDATE_FAKE_GUI_DETECT, packetBuffer -> {
                packetBuffer.func_150787_b(toUpdate.size());
                for (Tuple tuple : toUpdate) {
                    packetBuffer.func_150787_b(((Integer)tuple.func_76341_a()).intValue());
                    packetBuffer.func_150788_a((ItemStack)tuple.func_76340_b());
                }
            });
        }
        this.modularUI.guiWidgets.values().forEach(Widget::detectAndSendChanges);
    }

    @Override
    public void writeClientAction(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        if (this.behavior != null) {
            this.behavior.writePluginAction(GregtechDataCodes.ACTION_FAKE_GUI, buffer -> {
                buffer.func_150787_b(this.syncId);
                buffer.func_150787_b(this.windowId);
                buffer.func_150787_b(((Integer)this.modularUI.guiWidgets.inverse().get((Object)widget)).intValue());
                buffer.func_150787_b(updateId);
                payloadWriter.accept((PacketBuffer)buffer);
            });
        }
    }

    @Override
    public void writeUpdateInfo(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        if (this.behavior != null) {
            this.behavior.writePluginData(GregtechDataCodes.UPDATE_FAKE_GUI, buf -> {
                buf.func_150787_b(this.windowId);
                buf.func_150787_b(((Integer)this.modularUI.guiWidgets.inverse().get((Object)widget)).intValue());
                buf.func_150787_b(updateId);
                payloadWriter.accept((PacketBuffer)buf);
            });
        }
    }
}

