/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.crafting;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTStringUtils;
import gregtech.common.crafting.GTFluidCraftingIngredient;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jetbrains.annotations.NotNull;

public class GTShapedOreRecipe
extends ShapedOreRecipe {
    boolean isClearing;
    public static Constructor<IngredientNBT> ingredientNBT = ReflectionHelper.findConstructor(IngredientNBT.class, (Class[])new Class[]{ItemStack.class});

    public GTShapedOreRecipe(boolean isClearing, ResourceLocation group, @NotNull ItemStack result, Object ... recipe) {
        super(group, result, GTShapedOreRecipe.parseShaped(isClearing, recipe));
        this.isClearing = isClearing;
    }

    public static CraftingHelper.ShapedPrimer parseShaped(boolean isClearing, Object ... recipe) {
        CraftingHelper.ShapedPrimer ret = new CraftingHelper.ShapedPrimer();
        StringBuilder shape = new StringBuilder();
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            ret.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                ret.width = s.length();
                shape.append(s);
            }
            ret.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape.append(s);
                ret.width = s.length();
                ++ret.height;
            }
        }
        if (ret.width * ret.height != shape.length() || shape.length() == 0) {
            StringBuilder err = new StringBuilder("Invalid shaped recipe: ");
            for (Object tmp : recipe) {
                err.append(tmp).append(", ");
            }
            throw new RuntimeException(err.toString());
        }
        HashMap itemMap = Maps.newHashMap();
        itemMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            Ingredient ing = GTShapedOreRecipe.getIngredient(isClearing, in);
            if (' ' == chr.charValue()) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            if (ing == null) {
                StringBuilder err = new StringBuilder("Invalid shaped ore recipe: ");
                for (Object tmp : recipe) {
                    err.append(tmp).append(", ");
                }
                throw new RuntimeException(err.toString());
            }
            itemMap.put(chr, ing);
            idx += 2;
        }
        ret.input = NonNullList.func_191197_a((int)(ret.width * ret.height), (Object)Ingredient.field_193370_a);
        HashSet keys = Sets.newHashSet(itemMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (char chr : shape.toString().toCharArray()) {
            Ingredient ing = (Ingredient)itemMap.get(Character.valueOf(chr));
            if (ing == null) {
                throw new IllegalArgumentException("Pattern references symbol '" + chr + "' but it's not defined in the key");
            }
            ret.input.set(x++, (Object)ing);
            keys.remove(Character.valueOf(chr));
        }
        if (!keys.isEmpty()) {
            throw new IllegalArgumentException("Key defines symbols that aren't used in pattern: " + keys);
        }
        return ret;
    }

    protected static Ingredient getIngredient(boolean isClearing, Object obj) {
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        if (obj instanceof ItemStack) {
            IFluidHandlerItem handler;
            ItemStack ing = (ItemStack)obj;
            if (ing.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandlerItem)ing.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
                FluidStack drained = handler.drain(Integer.MAX_VALUE, false);
                if (drained != null && drained.amount > 0) {
                    return new GTFluidCraftingIngredient(((ItemStack)obj).func_77946_l());
                }
                if (!isClearing) {
                    ItemStack i = ((ItemStack)obj).func_77946_l();
                    try {
                        return (Ingredient)ingredientNBT.newInstance(i);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        GTLog.logger.error("Failure to instantiate an IngredientNBT of item {}", (Object)GTStringUtils.prettyPrintItemStack(i));
                    }
                }
            }
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)obj).func_77946_l()});
        }
        if (obj instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)obj));
        }
        if (obj instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)obj, 1, Short.MAX_VALUE)});
        }
        if (obj instanceof String) {
            return new OreIngredient((String)obj);
        }
        if (obj instanceof JsonElement) {
            throw new IllegalArgumentException("JsonObjects must use getIngredient(JsonObject, JsonContext)");
        }
        return null;
    }

    @NotNull
    public NonNullList<ItemStack> func_179532_b(@NotNull InventoryCrafting inv) {
        if (this.isClearing) {
            return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        return super.func_179532_b(inv);
    }
}

