/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.node;

import gregtech.common.covers.filter.oreglob.node.MatchDescription;
import gregtech.common.covers.filter.oreglob.node.NodeVisitor;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import org.jetbrains.annotations.NotNull;

class MatchNode
extends OreGlobNode {
    String match;
    boolean ignoreCase;

    MatchNode(String match, boolean ignoreCase) {
        this.match = match;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public void visit(NodeVisitor visitor) {
        visitor.match(this.match, this.ignoreCase, this.isNegated());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPropertyEqualTo(@NotNull OreGlobNode node) {
        if (!(node instanceof MatchNode)) return false;
        MatchNode match = (MatchNode)node;
        if (this.ignoreCase) {
            if (!this.match.equalsIgnoreCase(match.match)) return false;
            return true;
        } else if (!this.match.equals(match.match)) return false;
        return true;
    }

    @Override
    protected MatchDescription getIndividualNodeMatchDescription() {
        return this.isNegated() ? MatchDescription.OTHER_INCLUDING_EMPTY : MatchDescription.OTHER_EXCLUDING_EMPTY;
    }

    public boolean isMatchEquals(MatchNode other) {
        return this.ignoreCase ? this.match.equalsIgnoreCase(other.match) : this.match.equals(other.match);
    }

    public int getMatchLength() {
        return this.match.codePointCount(0, this.match.length());
    }
}

