/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.node;

public enum MatchDescription {
    EVERYTHING,
    NOTHING,
    NONEMPTY,
    EMPTY,
    OTHER_EXCLUDING_EMPTY,
    OTHER_INCLUDING_EMPTY;


    public boolean canMatchNonEmpty() {
        return this == EVERYTHING || this == NONEMPTY || this == OTHER_EXCLUDING_EMPTY || this == OTHER_INCLUDING_EMPTY;
    }

    public boolean canMatchNothing() {
        return this == EVERYTHING || this == EMPTY || this == OTHER_INCLUDING_EMPTY;
    }

    public boolean isComplete() {
        return !this.isIncomplete();
    }

    public boolean isIncomplete() {
        return this == OTHER_EXCLUDING_EMPTY || this == OTHER_INCLUDING_EMPTY;
    }

    public boolean covers(MatchDescription desc) {
        boolean bl;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EVERYTHING: {
                bl = true;
                break;
            }
            case NOTHING: 
            case OTHER_EXCLUDING_EMPTY: {
                if (desc == NOTHING) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case NONEMPTY: {
                if (!desc.canMatchNothing()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case EMPTY: 
            case OTHER_INCLUDING_EMPTY: {
                bl = !desc.canMatchNonEmpty();
            }
        }
        return bl;
    }

    public MatchDescription append(MatchDescription another) {
        MatchDescription matchDescription;
        if (another == NOTHING) {
            return NOTHING;
        }
        block0 : switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EVERYTHING: {
                switch (another) {
                    case NONEMPTY: {
                        matchDescription = NONEMPTY;
                        break block0;
                    }
                    case OTHER_EXCLUDING_EMPTY: {
                        matchDescription = OTHER_EXCLUDING_EMPTY;
                        break block0;
                    }
                    case OTHER_INCLUDING_EMPTY: {
                        matchDescription = OTHER_INCLUDING_EMPTY;
                        break block0;
                    }
                }
                matchDescription = EVERYTHING;
                break;
            }
            case NOTHING: {
                matchDescription = NOTHING;
                break;
            }
            case NONEMPTY: {
                switch (another) {
                    case OTHER_EXCLUDING_EMPTY: 
                    case NONEMPTY: 
                    case OTHER_INCLUDING_EMPTY: {
                        matchDescription = OTHER_EXCLUDING_EMPTY;
                        break block0;
                    }
                }
                matchDescription = NONEMPTY;
                break;
            }
            case EMPTY: {
                matchDescription = another;
                break;
            }
            case OTHER_EXCLUDING_EMPTY: {
                matchDescription = OTHER_EXCLUDING_EMPTY;
                break;
            }
            case OTHER_INCLUDING_EMPTY: {
                matchDescription = another.canMatchNothing() ? OTHER_INCLUDING_EMPTY : OTHER_EXCLUDING_EMPTY;
            }
        }
        return matchDescription;
    }

    public MatchDescription or(MatchDescription desc) {
        MatchDescription matchDescription;
        if (desc == NOTHING) {
            return this;
        }
        if (desc == EVERYTHING) {
            return EVERYTHING;
        }
        block0 : switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EVERYTHING: {
                matchDescription = EVERYTHING;
                break;
            }
            case NOTHING: {
                matchDescription = desc;
                break;
            }
            case NONEMPTY: {
                if (desc.canMatchNothing()) {
                    matchDescription = EVERYTHING;
                    break;
                }
                matchDescription = NONEMPTY;
                break;
            }
            case EMPTY: {
                switch (desc) {
                    case NONEMPTY: {
                        matchDescription = EVERYTHING;
                        break block0;
                    }
                    case OTHER_EXCLUDING_EMPTY: {
                        matchDescription = OTHER_INCLUDING_EMPTY;
                        break block0;
                    }
                }
                matchDescription = desc;
                break;
            }
            case OTHER_EXCLUDING_EMPTY: {
                switch (desc) {
                    case NONEMPTY: {
                        matchDescription = NONEMPTY;
                        break block0;
                    }
                    case OTHER_EXCLUDING_EMPTY: {
                        matchDescription = OTHER_EXCLUDING_EMPTY;
                        break block0;
                    }
                }
                matchDescription = OTHER_INCLUDING_EMPTY;
                break;
            }
            case OTHER_INCLUDING_EMPTY: {
                matchDescription = desc == NONEMPTY ? EVERYTHING : OTHER_INCLUDING_EMPTY;
            }
        }
        return matchDescription;
    }

    public MatchDescription and(MatchDescription desc) {
        MatchDescription matchDescription;
        if (desc == NOTHING) {
            return NOTHING;
        }
        if (desc == EVERYTHING) {
            return this;
        }
        if (this == desc) {
            return this;
        }
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EVERYTHING: {
                matchDescription = desc;
                break;
            }
            case NOTHING: {
                matchDescription = NOTHING;
                break;
            }
            case OTHER_EXCLUDING_EMPTY: 
            case NONEMPTY: {
                if (desc == EMPTY) {
                    matchDescription = NOTHING;
                    break;
                }
                matchDescription = OTHER_EXCLUDING_EMPTY;
                break;
            }
            case EMPTY: {
                if (desc.canMatchNothing()) {
                    matchDescription = EMPTY;
                    break;
                }
                matchDescription = NOTHING;
                break;
            }
            case OTHER_INCLUDING_EMPTY: {
                matchDescription = desc == EMPTY ? EMPTY : OTHER_EXCLUDING_EMPTY;
            }
        }
        return matchDescription;
    }

    public MatchDescription xor(MatchDescription desc) {
        MatchDescription matchDescription;
        if (this == desc) {
            return this.isComplete() ? NOTHING : OTHER_EXCLUDING_EMPTY;
        }
        if (this == NOTHING) {
            return desc;
        }
        if (desc == NOTHING) {
            return this;
        }
        if (this == EVERYTHING) {
            return desc.complement();
        }
        if (desc == EVERYTHING) {
            return this.complement();
        }
        block0 : switch (this) {
            case NONEMPTY: {
                if (desc == EMPTY) {
                    matchDescription = EVERYTHING;
                    break;
                }
                matchDescription = desc;
                break;
            }
            case EMPTY: {
                switch (desc) {
                    case NONEMPTY: {
                        matchDescription = EVERYTHING;
                        break block0;
                    }
                    case OTHER_EXCLUDING_EMPTY: {
                        matchDescription = OTHER_INCLUDING_EMPTY;
                        break block0;
                    }
                    case OTHER_INCLUDING_EMPTY: {
                        matchDescription = OTHER_EXCLUDING_EMPTY;
                        break block0;
                    }
                }
                throw new IllegalStateException("Unreachable");
            }
            case OTHER_EXCLUDING_EMPTY: {
                if (desc == NONEMPTY) {
                    matchDescription = OTHER_EXCLUDING_EMPTY;
                    break;
                }
                matchDescription = OTHER_INCLUDING_EMPTY;
                break;
            }
            case OTHER_INCLUDING_EMPTY: {
                if (desc == EMPTY) {
                    matchDescription = OTHER_EXCLUDING_EMPTY;
                    break;
                }
                matchDescription = OTHER_INCLUDING_EMPTY;
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable");
            }
        }
        return matchDescription;
    }

    public MatchDescription complement() {
        MatchDescription matchDescription;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EVERYTHING: {
                matchDescription = NOTHING;
                break;
            }
            case NOTHING: {
                matchDescription = EVERYTHING;
                break;
            }
            case NONEMPTY: {
                matchDescription = EMPTY;
                break;
            }
            case EMPTY: {
                matchDescription = NONEMPTY;
                break;
            }
            case OTHER_EXCLUDING_EMPTY: {
                matchDescription = OTHER_INCLUDING_EMPTY;
                break;
            }
            case OTHER_INCLUDING_EMPTY: {
                matchDescription = OTHER_EXCLUDING_EMPTY;
            }
        }
        return matchDescription;
    }
}

