/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.node;

import gregtech.common.covers.filter.oreglob.node.MatchDescription;
import gregtech.common.covers.filter.oreglob.node.NodeVisitor;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import org.jetbrains.annotations.NotNull;

class AnyCharNode
extends OreGlobNode {
    int amount;
    boolean more;

    AnyCharNode(int amount, boolean more) {
        this.amount = amount;
        this.more = more;
    }

    @Override
    public void visit(NodeVisitor visitor) {
        if (this.more) {
            visitor.charsOrMore(this.amount, this.isNegated());
        } else {
            visitor.chars(this.amount, this.isNegated());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPropertyEqualTo(@NotNull OreGlobNode node) {
        if (!(node instanceof AnyCharNode)) return false;
        AnyCharNode o = (AnyCharNode)node;
        if (this.amount != o.amount) return false;
        if (this.more != o.more) return false;
        return true;
    }

    @Override
    protected MatchDescription getIndividualNodeMatchDescription() {
        return this.isNegated() ? MatchDescription.OTHER_INCLUDING_EMPTY : MatchDescription.OTHER_EXCLUDING_EMPTY;
    }
}

