/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.util.Position;
import gregtech.common.covers.filter.FilterTypeRegistry;
import gregtech.common.covers.filter.FluidFilter;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class WidgetGroupFluidFilter
extends AbstractWidgetGroup {
    private final Supplier<FluidFilter> fluidFilterSupplier;
    private final Supplier<Boolean> showTipSupplier;
    private FluidFilter fluidFilter;

    public WidgetGroupFluidFilter(int yPosition, Supplier<FluidFilter> fluidFilterSupplier, Supplier<Boolean> showTipSupplier) {
        super(new Position(23, yPosition));
        this.fluidFilterSupplier = fluidFilterSupplier;
        this.showTipSupplier = showTipSupplier;
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        FluidFilter newFluidFilter = this.fluidFilterSupplier.get();
        if (this.fluidFilter != newFluidFilter) {
            this.clearAllWidgets();
            this.fluidFilter = newFluidFilter;
            if (this.fluidFilter != null) {
                this.fluidFilter.initUI(x$0 -> this.addWidget((Widget)x$0));
            }
            this.writeUpdateInfo(2, buffer -> {
                if (this.fluidFilter != null) {
                    buffer.writeBoolean(true);
                    int filterId = FilterTypeRegistry.getIdForFluidFilter(this.fluidFilter);
                    buffer.func_150787_b(filterId);
                } else {
                    buffer.writeBoolean(false);
                }
            });
        }
        if (this.fluidFilter != null && this.showTipSupplier != null && this.fluidFilter.showTip != this.showTipSupplier.get()) {
            this.fluidFilter.showTip = this.showTipSupplier.get();
            this.writeUpdateInfo(3, buffer -> buffer.writeBoolean(this.fluidFilter.showTip));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 2) {
            this.clearAllWidgets();
            if (buffer.readBoolean()) {
                int filterId = buffer.func_150792_a();
                this.fluidFilter = FilterTypeRegistry.createFluidFilterById(filterId);
                this.fluidFilter.initUI(x$0 -> this.addWidget((Widget)x$0));
            }
        } else if (id == 3) {
            this.fluidFilter.showTip = buffer.readBoolean();
        }
    }
}

