/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.covers.filter.FilterTypeRegistry;
import gregtech.common.covers.filter.ItemFilter;
import gregtech.common.covers.filter.ItemFilterWrapper;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ItemFilterContainer
implements INBTSerializable<NBTTagCompound> {
    private final ItemStackHandler filterInventory;
    private final ItemFilterWrapper filterWrapper;
    private int maxStackSizeLimit = 1;
    private int transferStackSize;

    public ItemFilterContainer(IDirtyNotifiable dirtyNotifiable) {
        this.filterWrapper = new ItemFilterWrapper(dirtyNotifiable);
        this.filterWrapper.setOnFilterInstanceChange(this::onFilterInstanceChange);
        this.filterInventory = new ItemStackHandler(1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return FilterTypeRegistry.getItemFilterForStack(stack) != null;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onLoad() {
                ItemFilterContainer.this.onFilterSlotChange(false);
            }

            protected void onContentsChanged(int slot) {
                ItemFilterContainer.this.onFilterSlotChange(true);
            }
        };
    }

    public ItemStackHandler getFilterInventory() {
        return this.filterInventory;
    }

    public ItemFilterWrapper getFilterWrapper() {
        return this.filterWrapper;
    }

    private void onFilterInstanceChange() {
        this.filterWrapper.setMaxStackSize(this.getTransferStackSize());
    }

    public int getMaxStackSize() {
        return this.maxStackSizeLimit;
    }

    public int getTransferStackSize() {
        if (!this.showGlobalTransferLimitSlider()) {
            return this.getMaxStackSize();
        }
        return this.transferStackSize;
    }

    public void setTransferStackSize(int transferStackSize) {
        this.transferStackSize = MathHelper.func_76125_a((int)transferStackSize, (int)1, (int)this.getMaxStackSize());
        this.filterWrapper.setMaxStackSize(this.getTransferStackSize());
    }

    public void adjustTransferStackSize(int amount) {
        this.setTransferStackSize(this.transferStackSize + amount);
    }

    public void initUI(int y, Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new LabelWidget(10, y, "cover.conveyor.item_filter.title", new Object[0]));
        widgetGroup.accept(new SlotWidget((IItemHandlerModifiable)this.filterInventory, 0, 10, y + 15).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY));
        this.filterWrapper.initUI(y + 38, widgetGroup);
        this.filterWrapper.blacklistUI(y + 38, widgetGroup, () -> true);
    }

    protected void onFilterSlotChange(boolean notify) {
        ItemStack filterStack = this.filterInventory.getStackInSlot(0);
        ItemFilter newItemFilter = FilterTypeRegistry.getItemFilterForStack(filterStack);
        ItemFilter currentItemFilter = this.filterWrapper.getItemFilter();
        if (newItemFilter == null) {
            if (currentItemFilter != null) {
                this.filterWrapper.setItemFilter(null);
                this.filterWrapper.setBlacklistFilter(false);
                if (notify) {
                    this.filterWrapper.onFilterInstanceChange();
                }
            }
        } else if (currentItemFilter == null || newItemFilter.getClass() != currentItemFilter.getClass()) {
            this.filterWrapper.setItemFilter(newItemFilter);
            if (notify) {
                this.filterWrapper.onFilterInstanceChange();
            }
        }
    }

    public void setMaxStackSize(int maxStackSizeLimit) {
        this.maxStackSizeLimit = maxStackSizeLimit;
        this.setTransferStackSize(this.transferStackSize);
    }

    public boolean showGlobalTransferLimitSlider() {
        return this.getMaxStackSize() > 1 && this.filterWrapper.showGlobalTransferLimitSlider();
    }

    public int getSlotTransferLimit(Object slotIndex) {
        return this.filterWrapper.getSlotTransferLimit(slotIndex, this.getTransferStackSize());
    }

    public Object matchItemStack(ItemStack itemStack) {
        return this.filterWrapper.matchItemStack(itemStack);
    }

    public Object matchItemStack(ItemStack itemStack, boolean whitelist) {
        return this.filterWrapper.matchItemStack(itemStack, whitelist);
    }

    public boolean testItemStack(ItemStack itemStack) {
        return this.matchItemStack(itemStack) != null;
    }

    public boolean testItemStack(ItemStack itemStack, boolean whitelist) {
        return this.matchItemStack(itemStack, whitelist) != null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74782_a("FilterInventory", (NBTBase)this.filterInventory.serializeNBT());
        tagCompound.func_74757_a("IsBlacklist", this.filterWrapper.isBlacklistFilter());
        tagCompound.func_74768_a("MaxStackSize", this.maxStackSizeLimit);
        tagCompound.func_74768_a("TransferStackSize", this.transferStackSize);
        if (this.filterWrapper.getItemFilter() != null) {
            NBTTagCompound filterInventory = new NBTTagCompound();
            this.filterWrapper.getItemFilter().writeToNBT(filterInventory);
            tagCompound.func_74782_a("Filter", (NBTBase)filterInventory);
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound tagCompound) {
        this.filterInventory.deserializeNBT(tagCompound.func_74775_l("FilterInventory"));
        this.filterWrapper.setBlacklistFilter(tagCompound.func_74767_n("IsBlacklist"));
        this.setMaxStackSize(tagCompound.func_74762_e("MaxStackSize"));
        this.setTransferStackSize(tagCompound.func_74762_e("TransferStackSize"));
        if (this.filterWrapper.getItemFilter() != null) {
            this.filterWrapper.getItemFilter().readFromNBT(tagCompound.func_74775_l("Filter"));
        }
    }
}

