/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.detector;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;

public abstract class CoverDetectorBase
extends CoverBase {
    protected static final String NBT_KEY_IS_INVERTED = "isInverted";
    private boolean isInverted = false;
    private int redstoneSignalOutput = 0;

    public CoverDetectorBase(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    protected boolean isInverted() {
        return this.isInverted;
    }

    protected void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
    }

    private void toggleInvertedWithNotification() {
        this.setInverted(!this.isInverted());
        CoverableView coverable = this.getCoverableView();
        if (!coverable.getWorld().field_72995_K) {
            coverable.writeCoverData(this, GregtechDataCodes.UPDATE_INVERTED, b -> b.writeBoolean(this.isInverted()));
            coverable.notifyBlockUpdate();
            coverable.markDirty();
        }
    }

    public final void setRedstoneSignalOutput(int redstoneSignalOutput) {
        this.redstoneSignalOutput = redstoneSignalOutput;
        this.getCoverableView().notifyBlockUpdate();
        this.getCoverableView().markDirty();
    }

    @Override
    public int getRedstoneSignalOutput() {
        return this.redstoneSignalOutput;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74757_a(NBT_KEY_IS_INVERTED, this.isInverted());
        if (this.redstoneSignalOutput > 0) {
            tagCompound.func_74768_a("RedstoneSignal", this.redstoneSignalOutput);
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        if (tagCompound.func_74764_b(NBT_KEY_IS_INVERTED)) {
            this.setInverted(tagCompound.func_74767_n(NBT_KEY_IS_INVERTED));
        }
        this.redstoneSignalOutput = tagCompound.func_74762_e("RedstoneSignal");
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeBoolean(this.isInverted());
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.setInverted(packetBuffer.readBoolean());
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        if (this.getWorld().field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        String translationKey = this.isInverted() ? "gregtech.cover.detector_base.message_inverted_state" : "gregtech.cover.detector_base.message_normal_state";
        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(translationKey, new Object[0]), true);
        this.toggleInvertedWithNotification();
        return EnumActionResult.SUCCESS;
    }

    protected static long parseCapped(String value, long minValue, long maxValue, long fallbackValue) {
        long parsedValue;
        try {
            parsedValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            parsedValue = fallbackValue;
        }
        return Math.min(Math.max(parsedValue, minValue), maxValue);
    }

    protected static int parseCapped(String value, int minValue, int maxValue, int fallbackValue) {
        int parsedValue;
        try {
            parsedValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            parsedValue = fallbackValue;
        }
        return Math.min(Math.max(parsedValue, minValue), maxValue);
    }
}

