/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GTValues;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockMaterialBase;
import gregtech.common.blocks.properties.PropertyMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockSurfaceRock
extends BlockMaterialBase {
    private static final AxisAlignedBB STONE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(GTUtility.gregtechId("surface_rock"), "normal");

    public static BlockSurfaceRock create(gregtech.api.unification.material.Material[] materials) {
        final PropertyMaterial property = PropertyMaterial.create("variant", materials);
        return new BlockSurfaceRock(){

            @Override
            @NotNull
            public PropertyMaterial getVariantProperty() {
                return property;
            }
        };
    }

    private BlockSurfaceRock() {
        super(Material.field_151572_C);
        this.func_149663_c("surface_rock");
        this.func_149711_c(0.25f);
    }

    @Nullable
    public String getHarvestTool(@NotNull IBlockState state) {
        return "shovel";
    }

    public boolean func_180639_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        playerIn.func_184609_a(hand);
        return true;
    }

    @NotNull
    public SoundType getSoundType(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @Nullable Entity entity) {
        return SoundType.field_185849_b;
    }

    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos) {
        return STONE_AABB;
    }

    private ItemStack getDropStack(IBlockState state, int amount) {
        return OreDictUnifier.get(OrePrefix.dustTiny, this.getGtMaterial(state), amount);
    }

    @NotNull
    public ItemStack getPickBlock(@NotNull IBlockState state, @NotNull RayTraceResult target, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        return this.getDropStack(state, 1);
    }

    public void getDrops(NonNullList<ItemStack> drops, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        int amount = 3 + GTValues.RNG.nextInt((int)(2.0 + (double)fortune * 1.5));
        drops.add((Object)this.getDropStack(state, amount));
    }

    public boolean func_149686_d(@NotNull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@NotNull IBlockState state) {
        return false;
    }

    public void func_189540_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, BlockPos fromPos) {
        if (fromPos.func_177984_a().equals((Object)pos) && worldIn.func_180495_p(fromPos).func_193401_d((IBlockAccess)worldIn, fromPos, EnumFacing.UP) != BlockFaceShape.SOLID) {
            worldIn.func_175655_b(pos, true);
        }
    }

    @NotNull
    public BlockFaceShape func_193383_a(@NotNull IBlockAccess worldIn, @NotNull IBlockState state, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

