/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.block.IStateHarvestLevel;
import gregtech.api.block.VariantBlock;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockCleanroomCasing
extends VariantBlock<CasingType>
implements IStateHarvestLevel {
    public BlockCleanroomCasing() {
        super(Material.field_151573_f);
        this.func_149663_c("cleanroom_casing");
        this.func_149711_c(2.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.getState(CasingType.PLASCRETE));
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public int getHarvestLevel(@NotNull IBlockState state) {
        return state == this.getState(CasingType.PLASCRETE) ? 2 : 1;
    }

    @Override
    @Nullable
    public String getHarvestTool(@NotNull IBlockState state) {
        return state == this.getState(CasingType.PLASCRETE) ? "pickaxe" : "wrench";
    }

    @Override
    public void func_190948_a(@NotNull ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, @NotNull ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        if (stack.func_77969_a(this.getItemVariant(CasingType.FILTER_CASING))) {
            tooltip.add(I18n.func_135052_a((String)"tile.cleanroom_casing.filter.tooltip", (Object[])new Object[0]));
        }
        if (stack.func_77969_a(this.getItemVariant(CasingType.FILTER_CASING_STERILE))) {
            tooltip.add(I18n.func_135052_a((String)"tile.cleanroom_casing.filter_sterile.tooltip", (Object[])new Object[0]));
        }
    }

    public static enum CasingType implements IStringSerializable
    {
        PLASCRETE("plascrete"),
        FILTER_CASING("filter_casing"),
        FILTER_CASING_STERILE("filter_casing_sterile");

        private final String name;

        private CasingType(String name) {
            this.name = name;
        }

        @NotNull
        public String func_176610_l() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return this.func_176610_l();
        }
    }
}

