/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import gregtech.api.GTValues;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;

public class TooltipHelper {
    private static final List<GTFormatCode> CODES = new ArrayList<GTFormatCode>();
    private static final TextFormatting[] ALL_COLORS = new TextFormatting[]{TextFormatting.RED, TextFormatting.GOLD, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.AQUA, TextFormatting.DARK_AQUA, TextFormatting.DARK_BLUE, TextFormatting.BLUE, TextFormatting.DARK_PURPLE, TextFormatting.LIGHT_PURPLE};
    public static final GTFormatCode RAINBOW_FAST = TooltipHelper.createNewCode(1, ALL_COLORS);
    public static final GTFormatCode RAINBOW = TooltipHelper.createNewCode(5, ALL_COLORS);
    public static final GTFormatCode RAINBOW_SLOW = TooltipHelper.createNewCode(25, ALL_COLORS);
    public static final GTFormatCode BLINKING_CYAN = TooltipHelper.createNewCode(5, TextFormatting.AQUA, TextFormatting.WHITE);
    public static final GTFormatCode BLINKING_RED = TooltipHelper.createNewCode(5, TextFormatting.RED, TextFormatting.WHITE);
    public static final GTFormatCode BLINKING_ORANGE = TooltipHelper.createNewCode(25, TextFormatting.GOLD, TextFormatting.YELLOW);
    public static final GTFormatCode BLINKING_GRAY = TooltipHelper.createNewCode(25, TextFormatting.GRAY, TextFormatting.DARK_GRAY);

    public static GTFormatCode createNewCode(int rate, TextFormatting ... codes) {
        if (rate <= 0) {
            GTLog.logger.error("Could not create GT Format Code with rate {}, must be greater than zero!", (Object)rate);
            return null;
        }
        if (codes == null || codes.length <= 1) {
            GTLog.logger.error("Could not create GT Format Code with codes {}, must have length greater than one!", (Object)Arrays.toString(codes));
            return null;
        }
        GTFormatCode code = new GTFormatCode(rate, codes);
        CODES.add(code);
        return code;
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CODES.forEach(rec$ -> ((GTFormatCode)rec$).updateIndex());
        }
    }

    public static boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean isCtrlDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static class GTFormatCode {
        private final int rate;
        private final TextFormatting[] codes;
        private int index = 0;

        private GTFormatCode(int rate, TextFormatting ... codes) {
            this.rate = rate;
            this.codes = codes;
        }

        private void updateIndex() {
            if (GTValues.CLIENT_TIME % (long)this.rate == 0L && !ConfigHolder.client.preventBlinkingTooltips) {
                this.index = this.index + 1 >= this.codes.length ? 0 : ++this.index;
            }
        }

        public String toString() {
            return this.codes[this.index].toString();
        }
    }
}

