/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.Mods;
import gregtech.client.particle.GTParticle;
import gregtech.client.renderer.IRenderSetup;
import gregtech.client.shader.Shaders;
import gregtech.client.shader.postprocessing.BloomEffect;
import gregtech.client.shader.postprocessing.BloomType;
import gregtech.client.utils.DepthTextureUtil;
import gregtech.client.utils.EffectRenderContext;
import gregtech.client.utils.IBloomEffect;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class BloomEffectUtil {
    private static final Map<BloomRenderKey, List<BloomRenderTicket>> BLOOM_RENDERS = new Object2ObjectOpenHashMap();
    private static final List<BloomRenderTicket> SCHEDULED_BLOOM_RENDERS = new ArrayList<BloomRenderTicket>();
    private static final ReentrantLock BLOOM_RENDER_LOCK = new ReentrantLock();
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public static BlockRenderLayer BLOOM;
    private static BlockRenderLayer bloom;
    private static Framebuffer bloomFBO;

    @NotNull
    public static BlockRenderLayer getBloomLayer() {
        return Objects.requireNonNull(bloom, "Bloom effect is not initialized yet");
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public static BlockRenderLayer getRealBloomLayer() {
        return BloomEffectUtil.getEffectiveBloomLayer();
    }

    @NotNull
    public static BlockRenderLayer getEffectiveBloomLayer() {
        return BloomEffectUtil.getEffectiveBloomLayer(BlockRenderLayer.CUTOUT);
    }

    @Contract(value="null -> _; !null -> !null")
    public static BlockRenderLayer getEffectiveBloomLayer(BlockRenderLayer fallback) {
        return Mods.Optifine.isModLoaded() ? fallback : bloom;
    }

    @NotNull
    public static BlockRenderLayer getEffectiveBloomLayer(boolean isBloomActive) {
        return BloomEffectUtil.getEffectiveBloomLayer(isBloomActive, BlockRenderLayer.CUTOUT);
    }

    @Contract(value="_, null -> _; _, !null -> !null")
    public static BlockRenderLayer getEffectiveBloomLayer(boolean isBloomActive, BlockRenderLayer fallback) {
        return Mods.Optifine.isModLoaded() || !isBloomActive ? fallback : bloom;
    }

    @Nullable
    public static Framebuffer getBloomFBO() {
        return bloomFBO;
    }

    @NotNull
    public static BloomRenderTicket registerBloomRender(@Nullable IRenderSetup setup, @NotNull BloomType bloomType, final @NotNull IBloomEffect render, final @NotNull MetaTileEntity metaTileEntity) {
        Objects.requireNonNull(metaTileEntity, "metaTileEntity == null");
        return BloomEffectUtil.registerBloomRender(setup, bloomType, new IBloomEffect(){

            @Override
            public void renderBloomEffect(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context) {
                render.renderBloomEffect(buffer, context);
            }

            @Override
            public boolean shouldRenderBloomEffect(@NotNull EffectRenderContext context) {
                return metaTileEntity.getWorld() == context.renderViewEntity().field_70170_p && render.shouldRenderBloomEffect(context);
            }
        }, t -> metaTileEntity.isValid(), metaTileEntity::getWorld);
    }

    @NotNull
    public static BloomRenderTicket registerBloomRender(@Nullable IRenderSetup setup, @NotNull BloomType bloomType, @NotNull IBloomEffect render, @NotNull GTParticle particle) {
        Objects.requireNonNull(particle, "particle == null");
        return BloomEffectUtil.registerBloomRender(setup, bloomType, render, (BloomRenderTicket t) -> particle.isAlive());
    }

    @NotNull
    public static BloomRenderTicket registerBloomRender(@Nullable IRenderSetup setup, @NotNull BloomType bloomType, @NotNull IBloomEffect render, @Nullable Predicate<BloomRenderTicket> validityChecker) {
        return BloomEffectUtil.registerBloomRender(setup, bloomType, render, validityChecker, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static BloomRenderTicket registerBloomRender(@Nullable IRenderSetup setup, @NotNull BloomType bloomType, @NotNull IBloomEffect render, @Nullable Predicate<BloomRenderTicket> validityChecker, @Nullable Supplier<World> worldContext) {
        if (Mods.Optifine.isModLoaded()) {
            return BloomRenderTicket.INVALID;
        }
        BloomRenderTicket ticket = new BloomRenderTicket(setup, bloomType, render, validityChecker, worldContext);
        BLOOM_RENDER_LOCK.lock();
        try {
            SCHEDULED_BLOOM_RENDERS.add(ticket);
        }
        finally {
            BLOOM_RENDER_LOCK.unlock();
        }
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateWorldTickets(@NotNull World world) {
        Objects.requireNonNull(world, "world == null");
        BLOOM_RENDER_LOCK.lock();
        try {
            for (BloomRenderTicket bloomRenderTicket : SCHEDULED_BLOOM_RENDERS) {
                if (!bloomRenderTicket.isValid() || bloomRenderTicket.worldContext == null || bloomRenderTicket.worldContext.get() != world) continue;
                bloomRenderTicket.invalidate();
            }
            for (Map.Entry entry : BLOOM_RENDERS.entrySet()) {
                for (BloomRenderTicket ticket : (List)entry.getValue()) {
                    if (!ticket.isValid() || ticket.worldContext == null || ticket.worldContext.get() != world) continue;
                    ticket.invalidate();
                }
            }
        }
        finally {
            BLOOM_RENDER_LOCK.unlock();
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public static void requestCustomBloom(IBloomRenderFast handler, Consumer<BufferBuilder> render) {
        BloomType bloomType = BloomType.fromValue(handler.customBloomStyle());
        Predicate<BloomRenderTicket> validityChecker = new Predicate<BloomRenderTicket>(){
            boolean invalid;

            @Override
            public boolean test(BloomRenderTicket bloomRenderTicket) {
                return !this.invalid;
            }
        };
        BloomEffectUtil.registerBloomRender((IRenderSetup)handler, bloomType, (arg_0, arg_1) -> BloomEffectUtil.lambda$requestCustomBloom$2(render, validityChecker, arg_0, arg_1), validityChecker);
    }

    public static void init() {
        BLOOM = bloom = (BlockRenderLayer)EnumHelper.addEnum(BlockRenderLayer.class, (String)"BLOOM", (Class[])new Class[]{String.class}, (Object[])new Object[]{"Bloom"});
        if (Mods.Nothirium.isModLoaded()) {
            try {
                Class<?> crp = Class.forName("meldexun.nothirium.api.renderer.chunk.ChunkRenderPass", false, (ClassLoader)Launch.classLoader);
                EnumHelper.addEnum(crp, (String)"BLOOM", (Class[])new Class[0], (Object[])new Object[0]);
                Field all = FieldUtils.getField(crp, (String)"ALL", (boolean)false);
                FieldUtils.removeFinalModifier((Field)all);
                FieldUtils.writeStaticField((Field)all, crp.getEnumConstants());
            }
            catch (ClassNotFoundException | IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void initBloomRenderLayer(BufferBuilder[] worldRenderers) {
        worldRenderers[BloomEffectUtil.bloom.ordinal()] = new BufferBuilder(131072);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int renderBloomBlockLayer(RenderGlobal renderGlobal, BlockRenderLayer blockRenderLayer, double partialTicks, int pass, @NotNull Entity entity) {
        Minecraft.func_71410_x().field_71424_I.func_76318_c("BTLayer");
        if (Mods.Optifine.isModLoaded()) {
            return renderGlobal.func_174977_a(blockRenderLayer, partialTicks, pass, entity);
        }
        BLOOM_RENDER_LOCK.lock();
        try {
            int n = BloomEffectUtil.renderBloomInternal(renderGlobal, blockRenderLayer, partialTicks, pass, entity);
            return n;
        }
        finally {
            BLOOM_RENDER_LOCK.unlock();
        }
    }

    private static int renderBloomInternal(RenderGlobal renderGlobal, BlockRenderLayer blockRenderLayer, double partialTicks, int pass, @NotNull Entity entity) {
        BloomEffectUtil.preDraw();
        EffectRenderContext context = EffectRenderContext.getInstance().update(entity, (float)partialTicks);
        if (!ConfigHolder.client.shader.emissiveTexturesBloom) {
            GlStateManager.func_179132_a((boolean)true);
            renderGlobal.func_174977_a(bloom, partialTicks, pass, entity);
            if (!BLOOM_RENDERS.isEmpty()) {
                BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
                for (List<BloomRenderTicket> list : BLOOM_RENDERS.values()) {
                    BloomEffectUtil.draw(buffer, context, list);
                }
            }
            BloomEffectUtil.postDraw();
            GlStateManager.func_179132_a((boolean)false);
            return renderGlobal.func_174977_a(blockRenderLayer, partialTicks, pass, entity);
        }
        Framebuffer fbo = Minecraft.func_71410_x().func_147110_a();
        if (bloomFBO == null || BloomEffectUtil.bloomFBO.field_147621_c != fbo.field_147621_c || BloomEffectUtil.bloomFBO.field_147618_d != fbo.field_147618_d || fbo.isStencilEnabled() && !bloomFBO.isStencilEnabled()) {
            if (bloomFBO == null) {
                bloomFBO = new Framebuffer(fbo.field_147621_c, fbo.field_147618_d, false);
                bloomFBO.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
            } else {
                bloomFBO.func_147613_a(fbo.field_147621_c, fbo.field_147618_d);
            }
            if (fbo.isStencilEnabled() && !bloomFBO.isStencilEnabled()) {
                bloomFBO.enableStencil();
            }
            if (DepthTextureUtil.isLastBind() && DepthTextureUtil.isUseDefaultFBO()) {
                RenderUtil.hookDepthTexture(bloomFBO, DepthTextureUtil.framebufferDepthTexture);
            } else {
                RenderUtil.hookDepthBuffer(bloomFBO, fbo.field_147624_h);
            }
            bloomFBO.func_147607_a(9729);
        }
        GlStateManager.func_179132_a((boolean)true);
        fbo.func_147610_a(true);
        if (!BLOOM_RENDERS.isEmpty()) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            for (List<BloomRenderTicket> list : BLOOM_RENDERS.values()) {
                BloomEffectUtil.draw(buffer, context, list);
            }
        }
        bloomFBO.func_147614_f();
        bloomFBO.func_147610_a(false);
        renderGlobal.func_174977_a(bloom, partialTicks, pass, entity);
        GlStateManager.func_179132_a((boolean)false);
        bloomFBO.func_147612_c();
        Shaders.renderFullImageInFBO(fbo, Shaders.IMAGE_F, null);
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)fbo.field_147616_f);
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179103_j((int)7425);
        int result = renderGlobal.func_174977_a(blockRenderLayer, partialTicks, pass, entity);
        Minecraft.func_71410_x().field_71424_I.func_76318_c("bloom");
        fbo.func_147612_c();
        GlStateManager.func_179112_b((int)772, (int)0);
        Shaders.renderFullImageInFBO(bloomFBO, Shaders.IMAGE_F, null);
        GlStateManager.func_179112_b((int)770, (int)771);
        BloomEffect.strength = (float)ConfigHolder.client.shader.strength;
        BloomEffect.baseBrightness = (float)ConfigHolder.client.shader.baseBrightness;
        BloomEffect.highBrightnessThreshold = (float)ConfigHolder.client.shader.highBrightnessThreshold;
        BloomEffect.lowBrightnessThreshold = (float)ConfigHolder.client.shader.lowBrightnessThreshold;
        BloomEffect.step = (float)ConfigHolder.client.shader.step;
        switch (ConfigHolder.client.shader.bloomStyle) {
            case 0: {
                BloomEffect.renderLOG(bloomFBO, fbo);
                break;
            }
            case 1: {
                BloomEffect.renderUnity(bloomFBO, fbo);
                break;
            }
            case 2: {
                BloomEffect.renderUnreal(bloomFBO, fbo);
                break;
            }
            default: {
                BloomEffectUtil.postDraw();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179084_k();
                return result;
            }
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179084_k();
        Shaders.renderFullImageInFBO(fbo, Shaders.IMAGE_F, null);
        if (!BLOOM_RENDERS.isEmpty()) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            block12: for (Map.Entry<BloomRenderKey, List<BloomRenderTicket>> e : BLOOM_RENDERS.entrySet()) {
                BloomRenderKey key = e.getKey();
                List<BloomRenderTicket> list = e.getValue();
                GlStateManager.func_179132_a((boolean)true);
                bloomFBO.func_147614_f();
                bloomFBO.func_147610_a(true);
                BloomEffectUtil.draw(buffer, context, list);
                GlStateManager.func_179132_a((boolean)false);
                fbo.func_147612_c();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)772, (int)0);
                Shaders.renderFullImageInFBO(bloomFBO, Shaders.IMAGE_F, null);
                GlStateManager.func_179112_b((int)770, (int)771);
                switch (key.bloomType) {
                    case GAUSSIAN: {
                        BloomEffect.renderLOG(bloomFBO, fbo);
                        break;
                    }
                    case UNITY: {
                        BloomEffect.renderUnity(bloomFBO, fbo);
                        break;
                    }
                    case UNREAL: {
                        BloomEffect.renderUnreal(bloomFBO, fbo);
                        break;
                    }
                    default: {
                        GlStateManager.func_179084_k();
                        continue block12;
                    }
                }
                GlStateManager.func_179084_k();
                Shaders.renderFullImageInFBO(fbo, Shaders.IMAGE_F, null);
            }
            BloomEffectUtil.postDraw();
        }
        return result;
    }

    private static void preDraw() {
        for (BloomRenderTicket ticket : SCHEDULED_BLOOM_RENDERS) {
            if (!ticket.isValid()) continue;
            BLOOM_RENDERS.computeIfAbsent(new BloomRenderKey(ticket.renderSetup, ticket.bloomType), k -> new ArrayList()).add(ticket);
        }
        SCHEDULED_BLOOM_RENDERS.clear();
    }

    private static void draw(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context, @NotNull List<BloomRenderTicket> tickets) {
        boolean initialized = false;
        IRenderSetup renderSetup = null;
        for (BloomRenderTicket ticket : tickets) {
            ticket.checkValidity();
            if (!ticket.isValid() || !ticket.render.shouldRenderBloomEffect(context)) continue;
            if (!initialized) {
                initialized = true;
                renderSetup = ticket.renderSetup;
                if (renderSetup != null) {
                    renderSetup.preDraw(buffer);
                }
            }
            ticket.render.renderBloomEffect(buffer, context);
        }
        if (initialized && renderSetup != null) {
            renderSetup.postDraw(buffer);
        }
    }

    private static void postDraw() {
        Iterator<List<BloomRenderTicket>> it = BLOOM_RENDERS.values().iterator();
        while (it.hasNext()) {
            List<BloomRenderTicket> list = it.next();
            if (!list.isEmpty() && (!list.removeIf(ticket -> {
                ((BloomRenderTicket)ticket).checkValidity();
                return !ticket.isValid();
            }) || !list.isEmpty())) continue;
            it.remove();
        }
    }

    private static /* synthetic */ void lambda$requestCustomBloom$2(Consumer render, 2 validityChecker, BufferBuilder b, EffectRenderContext c) {
        render.accept(b);
        validityChecker.invalid = true;
    }

    public static final class BloomRenderTicket {
        public static final BloomRenderTicket INVALID = new BloomRenderTicket();
        @Nullable
        private final IRenderSetup renderSetup;
        private final BloomType bloomType;
        private final IBloomEffect render;
        @Nullable
        private final Predicate<BloomRenderTicket> validityChecker;
        @Nullable
        private final Supplier<World> worldContext;
        private boolean invalidated;

        BloomRenderTicket() {
            this(null, BloomType.DISABLED, (b, c) -> {}, null, null);
            this.invalidated = true;
        }

        BloomRenderTicket(@Nullable IRenderSetup renderSetup, @NotNull BloomType bloomType, @NotNull IBloomEffect render, @Nullable Predicate<BloomRenderTicket> validityChecker, @Nullable Supplier<World> worldContext) {
            this.renderSetup = renderSetup;
            this.bloomType = Objects.requireNonNull(bloomType, "bloomType == null");
            this.render = Objects.requireNonNull(render, "render == null");
            this.validityChecker = validityChecker;
            this.worldContext = worldContext;
        }

        @Deprecated
        @Nullable
        @ApiStatus.ScheduledForRemoval(inVersion="2.9")
        public IRenderSetup getRenderSetup() {
            return this.renderSetup;
        }

        @Deprecated
        @NotNull
        @ApiStatus.ScheduledForRemoval(inVersion="2.9")
        public BloomType getBloomType() {
            return this.bloomType;
        }

        public boolean isValid() {
            return !this.invalidated;
        }

        public void invalidate() {
            this.invalidated = true;
        }

        private void checkValidity() {
            if (!this.invalidated && this.validityChecker != null && !this.validityChecker.test(this)) {
                this.invalidate();
            }
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public static interface IBloomRenderFast
    extends IRenderSetup {
        public int customBloomStyle();
    }

    private static final class BloomRenderKey {
        @Nullable
        private final IRenderSetup renderSetup;
        @NotNull
        private final BloomType bloomType;

        private BloomRenderKey(@Nullable IRenderSetup renderSetup, @NotNull BloomType bloomType) {
            this.renderSetup = renderSetup;
            this.bloomType = bloomType;
        }

        public String toString() {
            return "BloomRenderKey[" + "renderSetup=" + this.renderSetup + "," + "bloomType=" + (Object)((Object)this.bloomType) + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.renderSetup != null ? this.renderSetup.hashCode() : 0);
            result = 31 * result + (this.bloomType != null ? this.bloomType.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((BloomRenderKey)arg0).renderSetup, this.renderSetup)) {
                return false;
            }
            return Objects.equals((Object)((BloomRenderKey)arg0).bloomType, (Object)this.bloomType);
            {
            }
        }

        @Nullable
        public IRenderSetup renderSetup() {
            return this.renderSetup;
        }

        @NotNull
        public BloomType bloomType() {
            return this.bloomType;
        }
    }
}

