/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.pipe;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.pipelike.laser.LaserPipeType;
import gregtech.common.pipelike.laser.tile.TileEntityLaserPipe;
import java.util.EnumMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class LaserPipeRenderer
extends PipeRenderer {
    public static final LaserPipeRenderer INSTANCE = new LaserPipeRenderer();
    private final EnumMap<LaserPipeType, TextureAtlasSprite> pipeTextures = new EnumMap(LaserPipeType.class);
    private boolean active = false;

    public LaserPipeRenderer() {
        super("gt_laser_pipe", GTUtility.gregtechId("laser_pipe"));
    }

    @Override
    public void registerIcons(TextureMap map) {
        this.pipeTextures.put(LaserPipeType.NORMAL, Textures.LASER_PIPE_IN);
    }

    @Override
    public void buildRenderer(PipeRenderer.PipeRenderContext renderContext, BlockPipe<?, ?, ?> blockPipe, @Nullable IPipeTile<?, ?> pipeTile, IPipeType<?> pipeType, @Nullable Material material) {
        if (pipeType instanceof LaserPipeType) {
            TileEntityLaserPipe laserPipe;
            renderContext.addOpenFaceRender(new IVertexOperation[]{new IconTransformation(this.pipeTextures.get(pipeType))}).addSideRender(false, new IVertexOperation[]{new IconTransformation(Textures.LASER_PIPE_SIDE)});
            if (pipeTile != null && pipeTile.isPainted()) {
                renderContext.addSideRender(new IVertexOperation[]{new IconTransformation(Textures.LASER_PIPE_OVERLAY)});
            }
            this.active = !ConfigHolder.client.preventAnimatedCables && pipeTile instanceof TileEntityLaserPipe && (laserPipe = (TileEntityLaserPipe)pipeTile).isActive();
        }
    }

    @Override
    protected void renderOtherLayers(BlockRenderLayer layer, CCRenderState renderState, PipeRenderer.PipeRenderContext renderContext) {
        if (this.active && layer == BloomEffectUtil.getEffectiveBloomLayer() && (renderContext.getConnections() & 0x3F) != 0) {
            Cuboid6 innerCuboid = BlockPipe.getSideBox(null, renderContext.getPipeThickness());
            if ((renderContext.getConnections() & 0x3F) != 0) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    if ((renderContext.getConnections() & 1 << side.func_176745_a()) == 0) {
                        int oppositeIndex = side.func_176734_d().func_176745_a();
                        if ((renderContext.getConnections() & 1 << oppositeIndex) > 0 && (renderContext.getConnections() & 0x3F & ~(1 << oppositeIndex)) == 0) continue;
                        Object[] ops = renderContext.getBaseVertexOperation();
                        ops = (IVertexOperation[])ArrayUtils.addAll((Object[])ops, (Object[])new IVertexOperation[]{new IconTransformation(Textures.LASER_PIPE_OVERLAY_EMISSIVE)});
                        this.renderFace(renderState, (IVertexOperation[])ops, side, innerCuboid);
                        continue;
                    }
                    Cuboid6 sideCuboid = BlockPipe.getSideBox(side, renderContext.getPipeThickness());
                    for (EnumFacing connectionSide : EnumFacing.field_82609_l) {
                        if (connectionSide.func_176740_k() == side.func_176740_k()) continue;
                        Object[] ops = renderContext.getBaseVertexOperation();
                        ops = (IVertexOperation[])ArrayUtils.addAll((Object[])ops, (Object[])new IVertexOperation[]{new IconTransformation(Textures.LASER_PIPE_OVERLAY_EMISSIVE)});
                        this.renderFace(renderState, (IVertexOperation[])ops, connectionSide, sideCuboid);
                    }
                }
            }
        }
    }

    @Override
    protected boolean canRenderInLayer(BlockRenderLayer layer) {
        return super.canRenderInLayer(layer) || layer == BloomEffectUtil.getEffectiveBloomLayer();
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IPipeType<?> pipeType, @Nullable Material material) {
        return Textures.LASER_PIPE_SIDE;
    }
}

