/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.pipe;

import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.common.pipelike.cable.Insulation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CableRenderer
extends PipeRenderer {
    public static final CableRenderer INSTANCE = new CableRenderer();
    private final TextureAtlasSprite[] insulationTextures = new TextureAtlasSprite[6];
    private TextureAtlasSprite wireTexture;

    private CableRenderer() {
        super("gt_cable", GTUtility.gregtechId("cable"));
    }

    @Override
    public void registerIcons(TextureMap map) {
        ResourceLocation wireLocation = GTUtility.gregtechId("blocks/cable/wire");
        this.wireTexture = map.func_174942_a(wireLocation);
        for (int i = 0; i < this.insulationTextures.length; ++i) {
            ResourceLocation location = GTUtility.gregtechId("blocks/cable/insulation_" + i);
            this.insulationTextures[i] = map.func_174942_a(location);
        }
    }

    @Override
    public void buildRenderer(PipeRenderer.PipeRenderContext renderContext, BlockPipe<?, ?, ?> blockPipe, IPipeTile<?, ?> pipeTile, IPipeType<?> pipeType, @Nullable Material material) {
        if (material == null || !(pipeType instanceof Insulation)) {
            return;
        }
        int insulationLevel = ((Insulation)pipeType).insulationLevel;
        IconTransformation wireRender = new IconTransformation(this.wireTexture);
        ColourMultiplier wireColor = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(material.getMaterialRGB()));
        ColourMultiplier insulationColor = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(0x404040));
        if (pipeTile != null) {
            if (pipeTile.getPaintingColor() != pipeTile.getDefaultPaintingColor()) {
                wireColor.colour = GTUtility.convertRGBtoOpaqueRGBA_CL(pipeTile.getPaintingColor());
            }
            insulationColor.colour = GTUtility.convertRGBtoOpaqueRGBA_CL(pipeTile.getPaintingColor());
        }
        if (insulationLevel != -1) {
            if ((renderContext.getConnections() & 0x3F) == 0) {
                renderContext.addOpenFaceRender(false, new IVertexOperation[]{new IconTransformation(this.insulationTextures[5]), insulationColor});
                return;
            }
            renderContext.addOpenFaceRender(false, new IVertexOperation[]{wireRender, wireColor}).addOpenFaceRender(false, new IVertexOperation[]{new IconTransformation(this.insulationTextures[insulationLevel]), insulationColor}).addSideRender(false, new IVertexOperation[]{new IconTransformation(this.insulationTextures[5]), insulationColor});
        } else {
            renderContext.addOpenFaceRender(false, new IVertexOperation[]{wireRender, wireColor}).addSideRender(false, new IVertexOperation[]{wireRender, wireColor});
        }
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IPipeType<?> pipeType, @Nullable Material material) {
        return null;
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture(IPipeTile<?, ?> pipeTile) {
        int particleColor;
        TextureAtlasSprite atlasSprite;
        if (pipeTile == null) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        IPipeType pipeType = (IPipeType)pipeTile.getPipeType();
        if (!(pipeType instanceof Insulation)) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        Material material = pipeTile instanceof TileEntityMaterialPipeBase ? ((TileEntityMaterialPipeBase)pipeTile).getPipeMaterial() : null;
        int insulationLevel = ((Insulation)pipeType).insulationLevel;
        if (insulationLevel == -1) {
            atlasSprite = this.wireTexture;
            particleColor = material == null ? 0xFFFFFF : material.getMaterialRGB();
        } else {
            atlasSprite = this.insulationTextures[5];
            particleColor = pipeTile.getPaintingColor();
        }
        return Pair.of((Object)atlasSprite, (Object)particleColor);
    }
}

