/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import gregtech.api.util.GTLog;
import gregtech.client.particle.GTParticle;
import gregtech.client.renderer.IRenderSetup;
import gregtech.client.utils.EffectRenderContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class GTParticleManager {
    public static final GTParticleManager INSTANCE = new GTParticleManager();
    @Nullable
    private static World currentWorld = null;
    private final Map<@Nullable IRenderSetup, ArrayDeque<GTParticle>> depthEnabledParticles = new Object2ObjectLinkedOpenHashMap();
    private final Map<@Nullable IRenderSetup, ArrayDeque<GTParticle>> depthDisabledParticles = new Object2ObjectLinkedOpenHashMap();
    private final List<GTParticle> newParticleQueue = new ArrayList<GTParticle>();

    public void addEffect(@NotNull GTParticle particles) {
        this.newParticleQueue.add(particles);
    }

    public void updateEffects() {
        if (!this.depthEnabledParticles.isEmpty()) {
            this.updateQueue(this.depthEnabledParticles);
        }
        if (!this.depthDisabledParticles.isEmpty()) {
            this.updateQueue(this.depthDisabledParticles);
        }
        if (!this.newParticleQueue.isEmpty()) {
            for (GTParticle particle : this.newParticleQueue) {
                Map<IRenderSetup, ArrayDeque<GTParticle>> queue = particle.shouldDisableDepth() ? this.depthDisabledParticles : this.depthEnabledParticles;
                ArrayDeque particles = queue.computeIfAbsent(particle.getRenderSetup(), setup -> new ArrayDeque());
                if (particles.size() > 6000) {
                    ((GTParticle)particles.removeFirst()).setExpired();
                }
                particles.add(particle);
            }
            this.newParticleQueue.clear();
        }
    }

    private void updateQueue(Map<IRenderSetup, ArrayDeque<GTParticle>> renderQueue) {
        Iterator<ArrayDeque<GTParticle>> it = renderQueue.values().iterator();
        while (it.hasNext()) {
            ArrayDeque<GTParticle> particles = it.next();
            Iterator<GTParticle> it2 = particles.iterator();
            while (it2.hasNext()) {
                GTParticle particle = it2.next();
                if (particle.isAlive()) {
                    try {
                        particle.onUpdate();
                    }
                    catch (RuntimeException exception) {
                        GTLog.logger.error("particle update error: {}", (Object)particle.toString(), (Object)exception);
                        particle.setExpired();
                    }
                    if (particle.isAlive()) continue;
                }
                it2.remove();
            }
            if (!particles.isEmpty()) continue;
            it.remove();
        }
    }

    public void clearAllEffects(boolean cleanNewQueue) {
        if (cleanNewQueue) {
            for (GTParticle gTParticle : this.newParticleQueue) {
                gTParticle.setExpired();
            }
            this.newParticleQueue.clear();
        }
        for (ArrayDeque arrayDeque : this.depthEnabledParticles.values()) {
            for (GTParticle particle : arrayDeque) {
                particle.setExpired();
            }
        }
        for (ArrayDeque arrayDeque : this.depthDisabledParticles.values()) {
            for (GTParticle particle : arrayDeque) {
                particle.setExpired();
            }
        }
        this.depthEnabledParticles.clear();
        this.depthDisabledParticles.clear();
    }

    public void renderParticles(@NotNull Entity renderViewEntity, float partialTicks) {
        if (this.depthEnabledParticles.isEmpty() && this.depthDisabledParticles.isEmpty()) {
            return;
        }
        EffectRenderContext instance = EffectRenderContext.getInstance().update(renderViewEntity, partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179140_f();
        if (!this.depthDisabledParticles.isEmpty()) {
            GlStateManager.func_179132_a((boolean)false);
            GTParticleManager.renderGlParticlesInLayer(this.depthDisabledParticles, instance);
            GlStateManager.func_179132_a((boolean)true);
        }
        GTParticleManager.renderGlParticlesInLayer(this.depthEnabledParticles, instance);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    private static void renderGlParticlesInLayer(@NotNull Map<@Nullable IRenderSetup, ArrayDeque<GTParticle>> renderQueue, @NotNull EffectRenderContext context) {
        for (Map.Entry<IRenderSetup, ArrayDeque<GTParticle>> e : renderQueue.entrySet()) {
            @Nullable IRenderSetup handler = e.getKey();
            ArrayDeque<GTParticle> particles = e.getValue();
            if (particles.isEmpty()) continue;
            boolean initialized = false;
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            for (GTParticle particle : particles) {
                if (!particle.shouldRender(context)) continue;
                try {
                    if (!initialized) {
                        initialized = true;
                        if (handler != null) {
                            handler.preDraw(buffer);
                        }
                    }
                    particle.renderParticle(buffer, context);
                }
                catch (Throwable throwable) {
                    GTLog.logger.error("particle render error: {}", (Object)particle.toString(), (Object)throwable);
                    particle.setExpired();
                }
            }
            if (!initialized || handler == null) continue;
            handler.postDraw(buffer);
        }
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (currentWorld != world) {
            INSTANCE.clearAllEffects(currentWorld != null);
            currentWorld = world;
        }
        if (currentWorld != null) {
            INSTANCE.updateEffects();
        }
    }

    public static void renderWorld(RenderWorldLastEvent event) {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        INSTANCE.renderParticles((Entity)(entity == null ? Minecraft.func_71410_x().field_71439_g : entity), event.getPartialTicks());
    }

    public static void debugOverlay(RenderGameOverlayEvent.Text event) {
        if (event.getLeft().size() >= 5) {
            String particleTxt = (String)event.getLeft().get(4);
            particleTxt = particleTxt + "." + TextFormatting.GOLD + " PARTICLE-BACK: " + GTParticleManager.count(GTParticleManager.INSTANCE.depthEnabledParticles) + "PARTICLE-FRONT: " + GTParticleManager.count(GTParticleManager.INSTANCE.depthDisabledParticles);
            event.getLeft().set(4, particleTxt);
        }
    }

    private static int count(Map<@Nullable IRenderSetup, ArrayDeque<GTParticle>> renderQueue) {
        int g = 0;
        for (Deque deque : renderQueue.values()) {
            g += deque.size();
        }
        return g;
    }
}

