/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import codechicken.lib.vec.Cuboid6;
import gregtech.api.GTValues;
import gregtech.client.particle.GTBloomParticle;
import gregtech.client.renderer.IRenderSetup;
import gregtech.client.shader.postprocessing.BloomEffect;
import gregtech.client.shader.postprocessing.BloomType;
import gregtech.client.utils.EffectRenderContext;
import gregtech.client.utils.RenderBufferHelper;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTOverheatParticle
extends GTBloomParticle {
    private static final int[] blackBodyColors = new int[]{0xFF3300, 16732928, 16737536, 16741120, 16743936, 16746770, 16749356, 16751935, 16753999, 16756062, 16757867, 16759672, 16761220, 16762767, 0xFFCC99, 16765347, 16766381, 16767414, 16768446, 16769478, 16770254, 16771285, 16772060, 0xFFEEE3, 16773353, 0xFFF3EF, 0xFFF5F5, 0xFFF8FB, 0xFEF9FF, 0xF9F6FF, 0xF5F3FF, 0xF0F1FF, 0xEDEFFF, 15330815, 15133695, 14936575, 14739455, 14542591, 14345471, 14214143, 14082559, 13885695, 0xD1DFFF, 0xCFDDFF, 13556991, 13425663, 13294335, 13228543, 13097215, 13031679, 12900351, 12834559, 12768767, 12702975, 12637439, 12571647, 12505855, 12440319, 12374527, 12308991, 12243199, 12177663, 12111871, 12046335, 12046079, 11980543, 11914751, 11914751, 11848959, 11783423, 11783423, 11717631, 11717631, 11651839, 11651839, 11586303, 11520511, 11520511, 11520511, 11454975, 11454719, 11389183, 11389183, 11323391, 11323391, 11323391, 11257855, 11257599, 11192063, 11192063, 11192063, 11126527, 11126271, 11126271, 11126271, 11060735};
    private final TileEntityCable tileEntity;
    protected final int meltTemp;
    protected int temperature = 293;
    protected List<Cuboid6> pipeBoxes;
    protected boolean insulated;
    protected float alpha = 0.0f;
    protected int color = blackBodyColors[0];
    private static final IRenderSetup SETUP = new IRenderSetup(){
        float lastBrightnessX;
        float lastBrightnessY;

        @Override
        @SideOnly(value=Side.CLIENT)
        public void preDraw(@NotNull BufferBuilder buffer) {
            BloomEffect.strength = (float)ConfigHolder.client.shader.heatEffectBloom.strength;
            BloomEffect.baseBrightness = (float)ConfigHolder.client.shader.heatEffectBloom.baseBrightness;
            BloomEffect.highBrightnessThreshold = (float)ConfigHolder.client.shader.heatEffectBloom.highBrightnessThreshold;
            BloomEffect.lowBrightnessThreshold = (float)ConfigHolder.client.shader.heatEffectBloom.lowBrightnessThreshold;
            BloomEffect.step = 1.0f;
            this.lastBrightnessX = OpenGlHelper.lastBrightnessX;
            this.lastBrightnessY = OpenGlHelper.lastBrightnessY;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void postDraw(@NotNull BufferBuilder buffer) {
            buffer.func_178969_c(0.0, 0.0, 0.0);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.lastBrightnessX, (float)this.lastBrightnessY);
        }
    };

    public static int getBlackBodyColor(int temperature) {
        if (temperature < 1000) {
            return blackBodyColors[0];
        }
        int index = (temperature - 1000) / 200;
        if (index >= blackBodyColors.length - 1) {
            return blackBodyColors[blackBodyColors.length - 1];
        }
        int color = blackBodyColors[index];
        return RenderUtil.interpolateColor(color, blackBodyColors[index + 1], (float)(temperature % 200) / 200.0f);
    }

    public GTOverheatParticle(@NotNull TileEntityCable tileEntity, int meltTemp, @NotNull List<Cuboid6> pipeBoxes, boolean insulated) {
        super(tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p());
        this.tileEntity = tileEntity;
        this.meltTemp = meltTemp;
        this.pipeBoxes = pipeBoxes;
        this.updatePipeBoxes(pipeBoxes);
        this.insulated = insulated;
    }

    public void updatePipeBoxes(@NotNull List<Cuboid6> pipeBoxes) {
        this.pipeBoxes = pipeBoxes;
        for (Cuboid6 cuboid : this.pipeBoxes) {
            cuboid.expand(0.001);
        }
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
        if (temperature <= 293 || temperature > this.meltTemp) {
            this.setExpired();
            return;
        }
        if (temperature < 500) {
            this.alpha = 0.0f;
        } else if (temperature < 1000) {
            this.alpha = ((float)temperature - 500.0f) / 500.0f;
            this.alpha *= 0.8f;
        } else {
            this.alpha = 0.8f;
        }
        this.color = GTOverheatParticle.getBlackBodyColor(temperature);
    }

    @Override
    public void onUpdate() {
        if (this.tileEntity.func_145837_r() || !this.tileEntity.isParticleAlive()) {
            this.setExpired();
            return;
        }
        if (this.temperature > 400 && (double)GTValues.RNG.nextFloat() < 0.04) {
            this.spawnSmoke();
        }
    }

    private void spawnSmoke() {
        BlockPos pos = this.tileEntity.func_174877_v();
        float xPos = (float)pos.func_177958_n() + 0.5f;
        float yPos = (float)pos.func_177956_o() + 0.9f;
        float zPos = (float)pos.func_177952_p() + 0.5f;
        float ySpd = 0.3f + 0.1f * GTValues.RNG.nextFloat();
        this.tileEntity.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)ySpd, 0.0, new int[0]);
    }

    public String toString() {
        return "GTOverheatParticle{tileEntity=" + this.tileEntity + ", meltTemp=" + this.meltTemp + ", temperature=" + this.temperature + ", pipeBoxes=" + this.pipeBoxes + ", insulated=" + this.insulated + ", alpha=" + this.alpha + ", color=" + this.color + '}';
    }

    @Override
    @Nullable
    protected IRenderSetup getBloomRenderSetup() {
        return SETUP;
    }

    @Override
    @NotNull
    protected BloomType getBloomType() {
        ConfigHolder.HeatEffectBloom heatEffectBloom = ConfigHolder.client.shader.heatEffectBloom;
        return BloomType.fromValue(heatEffectBloom.useShader ? heatEffectBloom.bloomStyle : -1);
    }

    @Override
    public void renderBloomEffect(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context) {
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        buffer.func_178969_c(this.posX - context.cameraX(), this.posY - context.cameraY(), this.posZ - context.cameraZ());
        for (Cuboid6 cuboid : this.pipeBoxes) {
            RenderBufferHelper.renderCubeFace(buffer, cuboid, red, green, blue, this.alpha, true);
        }
    }

    @Override
    public boolean shouldRenderBloomEffect(@NotNull EffectRenderContext context) {
        if (this.insulated) {
            return false;
        }
        for (Cuboid6 cuboid : this.pipeBoxes) {
            if (context.camera().func_78548_b(cuboid.min.x + this.posX, cuboid.min.y + this.posY, cuboid.min.z + this.posZ, cuboid.max.x + this.posX, cuboid.max.y + this.posY, cuboid.max.z + this.posZ)) continue;
            return false;
        }
        return true;
    }
}

