/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.client.particle.GTParticle;
import gregtech.client.utils.EffectRenderContext;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class GTNameTagParticle
extends GTParticle {
    private final MetaTileEntityHolder metaTileEntityHolder;

    public GTNameTagParticle(@NotNull MetaTileEntityHolder metaTileEntityHolder, double posX, double posY, double posZ) {
        super(posX, posY, posZ);
        this.metaTileEntityHolder = Objects.requireNonNull(metaTileEntityHolder);
        this.setRenderRange(64.0);
    }

    @Override
    public void onUpdate() {
        if (this.metaTileEntityHolder.func_145837_r() || !this.metaTileEntityHolder.func_145831_w().func_175668_a(this.metaTileEntityHolder.func_174877_v(), false) || !this.metaTileEntityHolder.func_145818_k_()) {
            this.setExpired();
        }
    }

    @Override
    public void renderParticle(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context) {
        String name = this.metaTileEntityHolder.func_70005_c_();
        if (name.isEmpty()) {
            return;
        }
        Entity renderViewEntity = context.renderViewEntity();
        float rotationYaw = renderViewEntity.field_70126_B + (renderViewEntity.field_70177_z - renderViewEntity.field_70126_B) * context.partialTicks();
        float rotationPitch = renderViewEntity.field_70127_C + (renderViewEntity.field_70125_A - renderViewEntity.field_70127_C) * context.partialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(this.posX - context.cameraX()), (double)(this.posY - context.cameraY()), (double)(this.posZ - context.cameraZ()));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2;
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)(-width - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b((double)(-width - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b((double)(width + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b((double)(width + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(name, -width, 0, -1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public String toString() {
        return "GTNameTagParticle{metaTileEntityHolder=" + this.metaTileEntityHolder + ", posX=" + this.posX + ", posY=" + this.posY + ", posZ=" + this.posZ + '}';
    }
}

