/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model;

import gregtech.api.unification.ore.StoneType;
import gregtech.client.model.OreBakedModel;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import org.jetbrains.annotations.Nullable;

public class EmissiveOreBakedModel
extends OreBakedModel {
    private final List<BakedQuad>[] overlayQuads = new List[7];

    public EmissiveOreBakedModel(StoneType stoneType, IBakedModel overlay) {
        super(stoneType, overlay);
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (state == null || layer == null || !ConfigHolder.client.shader.useShader) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.getBaseModel().func_188616_a(null, side, 0L));
            quads.addAll(this.getOverlayQuads(side, rand));
            return quads;
        }
        if (layer == BlockRenderLayer.CUTOUT_MIPPED) {
            return this.getBaseModel().func_188616_a(null, side, 0L);
        }
        if (layer == BloomEffectUtil.getEffectiveBloomLayer()) {
            return this.getOverlayQuads(side, rand);
        }
        return Collections.emptyList();
    }

    protected List<BakedQuad> getOverlayQuads(@Nullable EnumFacing side, long rand) {
        int index;
        int n = index = side == null ? 6 : side.func_176745_a();
        if (this.overlayQuads[index] == null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.overlay.func_188616_a(null, side, rand));
            for (int i = 0; i < quads.size(); ++i) {
                quads.set(i, RenderUtil.makeEmissive((BakedQuad)quads.get(i)));
            }
            this.overlayQuads[index] = quads;
            return this.overlayQuads[index];
        }
        return this.overlayQuads[index];
    }
}

