/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.shape;

import com.google.gson.JsonObject;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.api.worldgen.shape.IBlockGeneratorAccess;
import gregtech.api.worldgen.shape.ShapeGenerator;
import java.util.Random;
import net.minecraft.util.math.Vec3i;

public class PlateGenerator
extends ShapeGenerator {
    private int minLength;
    private int maxLength;
    private int minDepth;
    private int maxDepth;
    private int minHeight;
    private int maxHeight;
    private float floorSharpness;
    private float roofSharpness;

    @Override
    public void loadFromConfig(JsonObject object) {
        int[] length = OreConfigUtils.getIntRange(object.get("length"));
        int[] depth = OreConfigUtils.getIntRange(object.get("depth"));
        int[] height = OreConfigUtils.getIntRange(object.get("height"));
        this.minLength = length[0];
        this.maxLength = length[1];
        this.minDepth = depth[0];
        this.maxDepth = depth[1];
        this.minHeight = height[0];
        this.maxHeight = height[1];
        this.floorSharpness = object.has("floor_sharpness") ? object.get("floor_sharpness").getAsFloat() : 0.3f;
        this.roofSharpness = object.has("roof_sharpness") ? object.get("roof_sharpness").getAsFloat() : 0.7f;
    }

    @Override
    public Vec3i getMaxSize() {
        int xzSize = Math.max(this.maxLength, this.maxDepth);
        return new Vec3i(xzSize * 2, this.maxDepth * 2, xzSize * 2);
    }

    @Override
    public void generate(Random gridRandom, IBlockGeneratorAccess relativeBlockAccess) {
        int length = (this.minLength == this.maxLength ? this.maxLength : this.minLength + gridRandom.nextInt(this.maxLength - this.minLength)) / 2;
        int depth = (this.minDepth == this.maxDepth ? this.maxDepth : this.minDepth + gridRandom.nextInt(this.maxDepth - this.minDepth)) / 2;
        int height = (this.minHeight == this.maxHeight ? this.maxHeight : this.minHeight + gridRandom.nextInt(this.maxHeight - this.minHeight)) / 2;
        boolean rotate = gridRandom.nextBoolean();
        for (int x = -length; x <= length; ++x) {
            for (int z = -depth; z <= depth; ++z) {
                boolean hasFloorSub = this.floorSharpness > gridRandom.nextFloat();
                boolean hasRoofSub = this.roofSharpness > gridRandom.nextFloat();
                for (int y = -height; y <= height; ++y) {
                    if (hasRoofSub && (y == height || gridRandom.nextBoolean())) continue;
                    hasRoofSub = false;
                    if (hasFloorSub && y == -height) continue;
                    relativeBlockAccess.generateBlock(rotate ? z : x, y, rotate ? x : z);
                }
            }
        }
    }
}

