/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.generator;

import gregtech.api.util.GTUtility;
import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class GTWorldGenCapability {
    private int maxHeight;
    private int maxBottomHeight;
    @CapabilityInject(value=GTWorldGenCapability.class)
    public static Capability<GTWorldGenCapability> CAPABILITY;
    private static final ResourceLocation CAPABILITY_ID;
    public static final Callable<GTWorldGenCapability> FACTORY;
    public static final Capability.IStorage<GTWorldGenCapability> STORAGE;

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.maxHeight = tagCompound.func_74762_e("H");
        this.maxBottomHeight = tagCompound.func_74764_b("BH") ? this.maxHeight : this.maxHeight;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        if (this.maxHeight != 0) {
            tagCompound.func_74768_a("H", this.maxHeight);
        }
        if (this.maxBottomHeight != this.maxHeight) {
            tagCompound.func_74768_a("BH", this.maxBottomHeight);
        }
        return tagCompound;
    }

    public void setFrom(GTWorldGenCapability other) {
        this.maxHeight = other.maxHeight;
        this.maxBottomHeight = other.maxBottomHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxBottomHeight() {
        return this.maxBottomHeight;
    }

    public void setMaxHeight(int maxHeight, int maxLiquidHeight) {
        this.maxHeight = maxHeight;
        this.maxBottomHeight = maxLiquidHeight;
    }

    @SubscribeEvent
    public static void attachChunkCapabilities(AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new WorldGenCapabilityProvider());
    }

    static {
        CAPABILITY_ID = GTUtility.gregtechId("worldgen");
        FACTORY = GTWorldGenCapability::new;
        STORAGE = new Capability.IStorage<GTWorldGenCapability>(){

            public NBTBase writeNBT(Capability<GTWorldGenCapability> capability, GTWorldGenCapability instance, EnumFacing side) {
                return instance.writeToNBT();
            }

            public void readNBT(Capability<GTWorldGenCapability> capability, GTWorldGenCapability instance, EnumFacing side, NBTBase nbt) {
                instance.readFromNBT((NBTTagCompound)nbt);
            }
        };
    }

    private static class WorldGenCapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        private final GTWorldGenCapability capabilityInstance = new GTWorldGenCapability();

        private WorldGenCapabilityProvider() {
        }

        public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CAPABILITY) {
                return (T)CAPABILITY.cast((Object)this.capabilityInstance);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.capabilityInstance.writeToNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.capabilityInstance.readFromNBT(nbt);
        }
    }
}

