/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.oreglob;

import gregtech.api.util.oreglob.OreGlob;
import java.util.Collection;

public final class OreGlobCompileResult {
    private final OreGlob instance;
    private final Report[] reports;

    public OreGlobCompileResult(OreGlob instance, Collection<Report> reports) {
        this.instance = instance;
        this.reports = (Report[])reports.stream().sorted().toArray(Report[]::new);
    }

    public OreGlob getInstance() {
        return this.instance;
    }

    public Report[] getReports() {
        return this.reports;
    }

    public boolean hasError() {
        for (Report report : this.reports) {
            if (!report.isError()) continue;
            return true;
        }
        return false;
    }

    public static final class Report
    implements Comparable<Report> {
        private final String message;
        private final boolean error;
        private final int start;
        private final int len;

        public Report(String message, boolean error) {
            this(message, error, -1, 0);
        }

        public Report(String message, boolean error, int start, int len) {
            this.message = message;
            this.error = error;
            this.start = start;
            this.len = len;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isError() {
            return this.error;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.len;
        }

        public String toString() {
            StringBuilder stb = new StringBuilder().append(this.error ? "[!] " : "[?] ");
            if (this.start >= 0) {
                stb.append("[").append(this.start + 1).append("] ");
            }
            return stb.append(this.message).toString();
        }

        @Override
        public int compareTo(Report o) {
            int i = Boolean.compare(o.error, this.error);
            return i != 0 ? i : Integer.compare(this.start, o.start);
        }
    }
}

