/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.function.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="gregtech")
public class TaskScheduler {
    private static final Map<World, TaskScheduler> tasksPerWorld = new HashMap<World, TaskScheduler>();
    private final List<Task> tasks = new ArrayList<Task>();
    private final List<Task> scheduledTasks = new ArrayList<Task>();
    private boolean running = false;

    @Nullable
    public static TaskScheduler get(World world) {
        return tasksPerWorld.get(world);
    }

    public static void scheduleTask(World world, Task task) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Attempt to schedule task on client world!");
        }
        tasksPerWorld.computeIfAbsent(world, k -> new TaskScheduler()).scheduleTask(task);
    }

    public void scheduleTask(Task task) {
        if (this.running) {
            this.scheduledTasks.add(task);
        } else {
            this.tasks.add(task);
        }
    }

    public void unload() {
        this.tasks.clear();
        this.scheduledTasks.clear();
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            tasksPerWorld.remove(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        TaskScheduler scheduler;
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.START && (scheduler = TaskScheduler.get(event.world)) != null) {
            if (!scheduler.scheduledTasks.isEmpty()) {
                scheduler.tasks.addAll(scheduler.scheduledTasks);
                scheduler.scheduledTasks.clear();
            }
            scheduler.running = true;
            scheduler.tasks.removeIf(task -> !task.run());
            scheduler.running = false;
        }
    }
}

