/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.util.function.Function;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public enum RelativeDirection {
    UP(f -> EnumFacing.UP),
    DOWN(f -> EnumFacing.DOWN),
    LEFT(EnumFacing::func_176735_f),
    RIGHT(EnumFacing::func_176746_e),
    FRONT(Function.identity()),
    BACK(EnumFacing::func_176734_d);

    final Function<EnumFacing, EnumFacing> actualFacing;

    private RelativeDirection(Function<EnumFacing, EnumFacing> actualFacing) {
        this.actualFacing = actualFacing;
    }

    public EnumFacing getActualFacing(EnumFacing facing) {
        return this.actualFacing.apply(facing);
    }

    public EnumFacing apply(EnumFacing facing) {
        return this.actualFacing.apply(facing);
    }

    public Vec3i applyVec3i(EnumFacing facing) {
        return this.apply(facing).func_176730_m();
    }

    public EnumFacing getRelativeFacing(EnumFacing frontFacing, EnumFacing upwardsFacing, boolean isFlipped) {
        EnumFacing enumFacing;
        EnumFacing.Axis frontAxis = frontFacing.func_176740_k();
        block0 : switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                if (frontAxis == EnumFacing.Axis.Y) {
                    enumFacing = upwardsFacing;
                    break;
                }
                switch (upwardsFacing) {
                    case NORTH: {
                        enumFacing = EnumFacing.UP;
                        break block0;
                    }
                    case SOUTH: {
                        enumFacing = EnumFacing.DOWN;
                        break block0;
                    }
                    case EAST: {
                        enumFacing = frontFacing.func_176735_f();
                        break block0;
                    }
                }
                enumFacing = frontFacing.func_176746_e();
                break;
            }
            case DOWN: {
                if (frontAxis == EnumFacing.Axis.Y) {
                    enumFacing = upwardsFacing.func_176734_d();
                    break;
                }
                switch (upwardsFacing) {
                    case NORTH: {
                        enumFacing = EnumFacing.DOWN;
                        break block0;
                    }
                    case SOUTH: {
                        enumFacing = EnumFacing.UP;
                        break block0;
                    }
                    case EAST: {
                        enumFacing = frontFacing.func_176746_e();
                        break block0;
                    }
                }
                enumFacing = frontFacing.func_176735_f();
                break;
            }
            case LEFT: {
                EnumFacing facing;
                if (frontAxis == EnumFacing.Axis.Y) {
                    facing = upwardsFacing.func_176746_e();
                } else {
                    switch (upwardsFacing) {
                        case NORTH: {
                            EnumFacing enumFacing2 = frontFacing.func_176735_f();
                            break;
                        }
                        case SOUTH: {
                            EnumFacing enumFacing2 = frontFacing.func_176746_e();
                            break;
                        }
                        case EAST: {
                            EnumFacing enumFacing2 = EnumFacing.DOWN;
                            break;
                        }
                        default: {
                            EnumFacing enumFacing2 = facing = EnumFacing.UP;
                        }
                    }
                }
                if (isFlipped) {
                    enumFacing = facing.func_176734_d();
                    break;
                }
                enumFacing = facing;
                break;
            }
            case RIGHT: {
                EnumFacing facing;
                if (frontAxis == EnumFacing.Axis.Y) {
                    facing = upwardsFacing.func_176735_f();
                } else {
                    switch (upwardsFacing) {
                        case NORTH: {
                            EnumFacing enumFacing3 = frontFacing.func_176746_e();
                            break;
                        }
                        case SOUTH: {
                            EnumFacing enumFacing3 = frontFacing.func_176735_f();
                            break;
                        }
                        case EAST: {
                            EnumFacing enumFacing3 = EnumFacing.UP;
                            break;
                        }
                        default: {
                            EnumFacing enumFacing3 = facing = EnumFacing.DOWN;
                        }
                    }
                }
                if (isFlipped) {
                    enumFacing = facing.func_176734_d();
                    break;
                }
                enumFacing = facing;
                break;
            }
            case FRONT: {
                enumFacing = frontFacing;
                break;
            }
            case BACK: {
                enumFacing = frontFacing.func_176734_d();
            }
        }
        return enumFacing;
    }

    public Function<BlockPos, Integer> getSorter(EnumFacing frontFacing, EnumFacing upwardsFacing, boolean isFlipped) {
        Function<BlockPos, Integer> function;
        EnumFacing sorterDirection = this.getRelativeFacing(frontFacing, upwardsFacing, isFlipped);
        switch (sorterDirection) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                function = Vec3i::func_177956_o;
                break;
            }
            case DOWN: {
                function = pos -> -pos.func_177956_o();
                break;
            }
            case EAST: {
                function = Vec3i::func_177958_n;
                break;
            }
            case WEST: {
                function = pos -> -pos.func_177958_n();
                break;
            }
            case NORTH: {
                function = pos -> -pos.func_177952_p();
                break;
            }
            case SOUTH: {
                function = Vec3i::func_177952_p;
            }
        }
        return function;
    }

    public static EnumFacing simulateAxisRotation(EnumFacing newFrontFacing, EnumFacing oldFrontFacing, EnumFacing upwardsFacing) {
        if (newFrontFacing == oldFrontFacing) {
            return upwardsFacing;
        }
        EnumFacing.Axis newAxis = newFrontFacing.func_176740_k();
        EnumFacing.Axis oldAxis = oldFrontFacing.func_176740_k();
        if (newAxis != EnumFacing.Axis.Y && oldAxis != EnumFacing.Axis.Y) {
            return upwardsFacing;
        }
        if (newAxis == EnumFacing.Axis.Y && oldAxis != EnumFacing.Axis.Y) {
            EnumFacing enumFacing;
            switch (upwardsFacing) {
                case NORTH: {
                    enumFacing = oldFrontFacing.func_176734_d();
                    break;
                }
                case SOUTH: {
                    enumFacing = oldFrontFacing;
                    break;
                }
                case EAST: {
                    enumFacing = oldFrontFacing.func_176735_f();
                    break;
                }
                default: {
                    enumFacing = oldFrontFacing.func_176746_e();
                }
            }
            EnumFacing newUpwardsFacing = enumFacing;
            return newFrontFacing == EnumFacing.DOWN && upwardsFacing.func_176740_k() == EnumFacing.Axis.Z ? newUpwardsFacing.func_176734_d() : newUpwardsFacing;
        }
        if (newAxis != EnumFacing.Axis.Y) {
            EnumFacing newUpwardsFacing = upwardsFacing == newFrontFacing.func_176734_d() ? EnumFacing.NORTH : (upwardsFacing == newFrontFacing ? EnumFacing.SOUTH : (upwardsFacing == newFrontFacing.func_176746_e() ? EnumFacing.WEST : EnumFacing.EAST));
            return oldFrontFacing == EnumFacing.DOWN && newUpwardsFacing.func_176740_k() == EnumFacing.Axis.Z ? newUpwardsFacing.func_176734_d() : newUpwardsFacing;
        }
        return upwardsFacing.func_176734_d();
    }

    public static BlockPos offsetPos(BlockPos pos, EnumFacing frontFacing, EnumFacing upwardsFacing, boolean isFlipped, int upOffset, int leftOffset, int forwardOffset) {
        if (upOffset == 0 && leftOffset == 0 && forwardOffset == 0) {
            return pos;
        }
        int oX = 0;
        int oY = 0;
        int oZ = 0;
        EnumFacing relUp = UP.getRelativeFacing(frontFacing, upwardsFacing, isFlipped);
        oX += relUp.func_82601_c() * upOffset;
        oY += relUp.func_96559_d() * upOffset;
        oZ += relUp.func_82599_e() * upOffset;
        EnumFacing relLeft = LEFT.getRelativeFacing(frontFacing, upwardsFacing, isFlipped);
        oX += relLeft.func_82601_c() * leftOffset;
        oY += relLeft.func_96559_d() * leftOffset;
        oZ += relLeft.func_82599_e() * leftOffset;
        EnumFacing relForward = FRONT.getRelativeFacing(frontFacing, upwardsFacing, isFlipped);
        return pos.func_177982_a(oX += relForward.func_82601_c() * forwardOffset, oY += relForward.func_96559_d() * forwardOffset, oZ += relForward.func_82599_e() * forwardOffset);
    }
}

