/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.ItemStackHandler;

public class LargeStackSizeItemStackHandler
extends ItemStackHandler {
    private static final String ITEM_LIST_TAG_KEY = "Items";
    private static final String ITEM_COUNT_TAG_KEY = "Count";
    private static final String BIG_STACK_SIZE_TAG_KEY = "BigStackSize";
    private static final Byte FAKE_STACK_SIZE = new Byte("1");

    public LargeStackSizeItemStackHandler(int maxMatchSlots) {
        super(maxMatchSlots);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = super.serializeNBT();
        if (this.stacks.stream().anyMatch(x -> x.func_190916_E() > 127)) {
            NBTTagCompound stackSizes = new NBTTagCompound();
            NBTTagList items = tagCompound.func_150295_c(ITEM_LIST_TAG_KEY, 10);
            for (int i = 0; i < this.stacks.size(); ++i) {
                ItemStack itemStack = (ItemStack)this.stacks.get(i);
                if (itemStack == ItemStack.field_190927_a || itemStack.func_190916_E() <= 127) continue;
                stackSizes.func_74768_a(String.valueOf(i), itemStack.func_190916_E());
            }
            tagCompound.func_74782_a(BIG_STACK_SIZE_TAG_KEY, (NBTBase)stackSizes);
            for (NBTBase itemBase : items) {
                NBTTagCompound item = (NBTTagCompound)itemBase;
                byte size = item.func_74771_c(ITEM_COUNT_TAG_KEY);
                if (size >= 0) continue;
                item.func_74774_a(ITEM_COUNT_TAG_KEY, FAKE_STACK_SIZE.byteValue());
            }
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound tagCompound) {
        super.deserializeNBT(tagCompound);
        if (tagCompound.func_74764_b(BIG_STACK_SIZE_TAG_KEY)) {
            NBTTagCompound stackSizes = tagCompound.func_74775_l(BIG_STACK_SIZE_TAG_KEY);
            for (String tagKey : stackSizes.func_150296_c()) {
                int size = stackSizes.func_74762_e(tagKey);
                int slot = Integer.parseInt(tagKey);
                ((ItemStack)this.stacks.get(slot)).func_190920_e(size);
            }
        }
    }
}

