/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.GTFluid;
import gregtech.api.unification.material.Material;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTooltipUtil {
    private static final Map<Fluid, List<Supplier<List<String>>>> tooltips = new HashMap<Fluid, List<Supplier<List<String>>>>();

    public static void registerTooltip(@NotNull Fluid fluid, @NotNull Supplier<List<String>> tooltip) {
        List list = tooltips.computeIfAbsent(fluid, $ -> new ArrayList(1));
        list.add(tooltip);
    }

    public static List<String> getFluidTooltip(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        List<Supplier<List<String>>> list = tooltips.get(fluid);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        for (Supplier<List<String>> supplier : list) {
            tooltip.addAll((Collection<String>)supplier.get());
        }
        return tooltip;
    }

    public static List<String> getFluidTooltip(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return FluidTooltipUtil.getFluidTooltip(stack.getFluid());
    }

    public static List<String> getFluidTooltip(String fluidName) {
        if (fluidName == null || fluidName.isEmpty()) {
            return null;
        }
        return FluidTooltipUtil.getFluidTooltip(FluidRegistry.getFluid((String)fluidName));
    }

    public static Supplier<List<String>> createGTFluidTooltip(@NotNull GTFluid fluid) {
        Material material;
        if (fluid instanceof GTFluid.GTMaterialFluid) {
            GTFluid.GTMaterialFluid matFluid = (GTFluid.GTMaterialFluid)fluid;
            material = matFluid.getMaterial();
        } else {
            material = null;
        }
        Material material2 = material;
        return FluidTooltipUtil.createFluidTooltip(material2, fluid, fluid.getState());
    }

    public static Supplier<List<String>> createFluidTooltip(@Nullable Material material, @NotNull Fluid fluid, @NotNull FluidState fluidState) {
        return () -> {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (material != null && !material.getChemicalFormula().isEmpty()) {
                tooltip.add(TextFormatting.YELLOW + material.getChemicalFormula());
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.fluid.temperature", (Object[])new Object[]{fluid.getTemperature()}));
            tooltip.add(I18n.func_135052_a((String)fluidState.getTranslationKey(), (Object[])new Object[0]));
            if (fluid instanceof GTFluid) {
                GTFluid gtFluid = (GTFluid)fluid;
                gtFluid.getAttributes().forEach(a -> a.appendFluidTooltips(tooltip));
            }
            if (fluid.getTemperature() < 120) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid.temperature.cryogenic", (Object[])new Object[0]));
            }
            return tooltip;
        };
    }
}

