/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.ore;

import com.google.common.base.Preconditions;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneTypes;
import gregtech.api.util.GTControlledRegistry;
import gregtech.api.util.Mods;
import gregtech.common.ConfigHolder;
import gregtech.integration.jei.basic.OreByProduct;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;

public class StoneType
implements Comparable<StoneType> {
    public final String name;
    public final OrePrefix processingPrefix;
    public final Material stoneMaterial;
    public final Supplier<IBlockState> stone;
    public final SoundType soundType;
    private final com.google.common.base.Predicate<IBlockState> predicate;
    public final boolean shouldBeDroppedAsItem;
    public static final GTControlledRegistry<String, StoneType> STONE_TYPE_REGISTRY = new GTControlledRegistry(128);
    private static final ThreadLocal<Boolean> hasDummyPredicateRan = ThreadLocal.withInitial(() -> false);
    private static final com.google.common.base.Predicate<IBlockState> dummyPredicate = state -> {
        hasDummyPredicateRan.set(true);
        return false;
    };

    public StoneType(int id, String name, SoundType soundType, OrePrefix processingPrefix, Material stoneMaterial, Supplier<IBlockState> stone, Predicate<IBlockState> predicate, boolean shouldBeDroppedAsItem) {
        Preconditions.checkArgument((boolean)stoneMaterial.hasProperty(PropertyKey.DUST), (Object)"Stone type must be made with a Material with the Dust Property!");
        this.name = name;
        this.soundType = soundType;
        this.processingPrefix = processingPrefix;
        this.stoneMaterial = stoneMaterial;
        this.stone = stone;
        this.predicate = predicate::test;
        this.shouldBeDroppedAsItem = shouldBeDroppedAsItem || ConfigHolder.worldgen.allUniqueStoneTypes;
        STONE_TYPE_REGISTRY.func_177775_a(id, name, this);
        if (Mods.JustEnoughItems.isModLoaded() && this.shouldBeDroppedAsItem) {
            OreByProduct.addOreByProductPrefix(this.processingPrefix);
        }
    }

    @Override
    public int compareTo(@NotNull StoneType stoneType) {
        return STONE_TYPE_REGISTRY.func_148757_b(this) - STONE_TYPE_REGISTRY.func_148757_b(stoneType);
    }

    public static void init() {
        StoneTypes.STONE.name.getBytes();
    }

    public static StoneType computeStoneType(IBlockState state, IBlockAccess world, BlockPos pos) {
        block3: {
            boolean dummy$isReplaceableOreGen;
            block2: {
                dummy$isReplaceableOreGen = state.func_177230_c().isReplaceableOreGen(state, world, pos, dummyPredicate);
                if (!hasDummyPredicateRan.get().booleanValue()) break block2;
                hasDummyPredicateRan.set(false);
                Iterator iterator = STONE_TYPE_REGISTRY.iterator();
                while (iterator.hasNext()) {
                    StoneType stoneType = (StoneType)iterator.next();
                    if (!state.func_177230_c().isReplaceableOreGen(state, world, pos, stoneType.predicate)) continue;
                    return stoneType;
                }
                break block3;
            }
            if (!dummy$isReplaceableOreGen) break block3;
            Iterator iterator = STONE_TYPE_REGISTRY.iterator();
            while (iterator.hasNext()) {
                StoneType stoneType = (StoneType)iterator.next();
                if (!stoneType.predicate.test((Object)state)) continue;
                return stoneType;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoneType stoneType = (StoneType)o;
        if (this.shouldBeDroppedAsItem != stoneType.shouldBeDroppedAsItem) {
            return false;
        }
        if (!this.name.equals(stoneType.name)) {
            return false;
        }
        if (!this.processingPrefix.equals(stoneType.processingPrefix)) {
            return false;
        }
        if (!this.stoneMaterial.equals(stoneType.stoneMaterial)) {
            return false;
        }
        if (!this.stone.equals(stoneType.stone)) {
            return false;
        }
        if (!this.soundType.equals(stoneType.soundType)) {
            return false;
        }
        return this.predicate.equals(stoneType.predicate);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.processingPrefix.hashCode();
        result = 31 * result + this.stoneMaterial.hashCode();
        result = 31 * result + this.stone.hashCode();
        result = 31 * result + this.soundType.hashCode();
        result = 31 * result + this.predicate.hashCode();
        result = 31 * result + (this.shouldBeDroppedAsItem ? 1 : 0);
        return result;
    }
}

