/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import org.jetbrains.annotations.NotNull;

public class RotorProperty
implements IMaterialProperty {
    private float speed;
    private float damage;
    private int durability;

    public RotorProperty(float speed, float damage, int durability) {
        this.speed = speed;
        this.damage = damage;
        this.durability = durability;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        if (speed <= 0.0f) {
            throw new IllegalArgumentException("Rotor Speed must be greater than zero!");
        }
        this.speed = speed;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        if (damage <= 0.0f) {
            throw new IllegalArgumentException("Rotor Attack Damage must be greater than zero!");
        }
        this.damage = damage;
    }

    public int getDurability() {
        return this.durability;
    }

    public void setDurability(int durability) {
        if (durability <= 0) {
            throw new IllegalArgumentException("Rotor Durability must be greater than zero!");
        }
        this.durability = durability;
    }

    @Override
    public void verifyProperty(@NotNull MaterialProperties properties) {
        properties.ensureSet(PropertyKey.INGOT, true);
    }
}

