/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.fluids.FluidBuilder;
import gregtech.api.fluids.store.FluidStorage;
import gregtech.api.fluids.store.FluidStorageImpl;
import gregtech.api.fluids.store.FluidStorageKey;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidProperty
implements IMaterialProperty,
FluidStorage {
    private final FluidStorageImpl storage = new FluidStorageImpl();
    private FluidStorageKey primaryKey = null;
    @Nullable
    private Fluid solidifyingFluid = null;

    public FluidProperty() {
    }

    public FluidProperty(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
        this.enqueueRegistration(key, builder);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    @NotNull
    public FluidStorage getStorage() {
        return this;
    }

    @ApiStatus.Internal
    public void registerFluids(@NotNull Material material) {
        this.storage.registerFluids(material);
    }

    @Override
    public void enqueueRegistration(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
        this.storage.enqueueRegistration(key, builder);
        if (this.primaryKey == null) {
            this.primaryKey = key;
        }
    }

    @Override
    public void store(@NotNull FluidStorageKey key, @NotNull Fluid fluid) {
        this.storage.store(key, fluid);
        if (this.primaryKey == null) {
            this.primaryKey = key;
        }
    }

    @Override
    @Nullable
    public Fluid get(@NotNull FluidStorageKey key) {
        return this.storage.get(key);
    }

    @Override
    @Nullable
    public FluidBuilder getQueuedBuilder(@NotNull FluidStorageKey key) {
        return this.storage.getQueuedBuilder(key);
    }

    @NotNull
    public FluidStorageKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(@NotNull FluidStorageKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (this.primaryKey == null) {
            throw new IllegalStateException("FluidProperty cannot be empty");
        }
    }

    @Nullable
    public Fluid solidifiesFrom() {
        if (this.solidifyingFluid == null) {
            return this.storage.get(FluidStorageKeys.LIQUID);
        }
        return this.solidifyingFluid;
    }

    public FluidStack solidifiesFrom(int amount) {
        return new FluidStack(this.solidifiesFrom(), amount);
    }

    public void setSolidifyingFluid(@Nullable Fluid solidifyingFluid) {
        this.solidifyingFluid = solidifyingFluid;
    }
}

