/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.capability.IPropertyFluidFilter;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.attribute.FluidAttribute;
import gregtech.api.fluids.attribute.FluidAttributes;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class FluidPipeProperties
implements IMaterialProperty,
IPropertyFluidFilter {
    private final Object2BooleanMap<FluidAttribute> containmentPredicate = new Object2BooleanOpenHashMap();
    private int throughput;
    private final int tanks;
    private int maxFluidTemperature;
    private boolean gasProof;
    private boolean cryoProof;
    private boolean plasmaProof;

    public FluidPipeProperties(int maxFluidTemperature, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
        this(maxFluidTemperature, throughput, gasProof, acidProof, cryoProof, plasmaProof, 1);
    }

    public FluidPipeProperties(int maxFluidTemperature, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof, int tanks) {
        this.maxFluidTemperature = maxFluidTemperature;
        this.throughput = throughput;
        this.gasProof = gasProof;
        if (acidProof) {
            this.setCanContain(FluidAttributes.ACID, true);
        }
        this.cryoProof = cryoProof;
        this.plasmaProof = plasmaProof;
        this.tanks = tanks;
    }

    public FluidPipeProperties() {
        this(300, 1, false, false, false, false);
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (!properties.hasProperty(PropertyKey.WOOD)) {
            properties.ensureSet(PropertyKey.INGOT, true);
        }
        if (properties.hasProperty(PropertyKey.ITEM_PIPE)) {
            throw new IllegalStateException("Material " + properties.getMaterial() + " has both Fluid and Item Pipe Property, which is not allowed!");
        }
    }

    public int getTanks() {
        return this.tanks;
    }

    public int getThroughput() {
        return this.throughput;
    }

    public void setThroughput(int throughput) {
        this.throughput = throughput;
    }

    @Override
    public int getMaxFluidTemperature() {
        return this.maxFluidTemperature;
    }

    public void setMaxFluidTemperature(int maxFluidTemperature) {
        this.maxFluidTemperature = maxFluidTemperature;
    }

    @Override
    public boolean canContain(@NotNull FluidState state) {
        boolean bl;
        switch (state) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LIQUID: {
                bl = true;
                break;
            }
            case GAS: {
                bl = this.gasProof;
                break;
            }
            case PLASMA: {
                bl = this.plasmaProof;
            }
        }
        return bl;
    }

    @Override
    public boolean canContain(@NotNull FluidAttribute attribute) {
        return this.containmentPredicate.getBoolean((Object)attribute);
    }

    @Override
    public void setCanContain(@NotNull FluidAttribute attribute, boolean canContain) {
        this.containmentPredicate.put((Object)attribute, canContain);
    }

    @Override
    @NotNull
    public @NotNull @UnmodifiableView Collection<@NotNull FluidAttribute> getContainedAttributes() {
        return this.containmentPredicate.keySet();
    }

    @Override
    public boolean isGasProof() {
        return this.gasProof;
    }

    public void setGasProof(boolean gasProof) {
        this.gasProof = gasProof;
    }

    public boolean isAcidProof() {
        return this.canContain(FluidAttributes.ACID);
    }

    @Override
    public boolean isCryoProof() {
        return this.cryoProof;
    }

    public void setCryoProof(boolean cryoProof) {
        this.cryoProof = cryoProof;
    }

    @Override
    public boolean isPlasmaProof() {
        return this.plasmaProof;
    }

    public void setPlasmaProof(boolean plasmaProof) {
        this.plasmaProof = plasmaProof;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FluidPipeProperties)) {
            return false;
        }
        FluidPipeProperties that = (FluidPipeProperties)o;
        return this.getThroughput() == that.getThroughput() && this.getTanks() == that.getTanks() && this.getMaxFluidTemperature() == that.getMaxFluidTemperature() && this.isGasProof() == that.isGasProof() && this.isCryoProof() == that.isCryoProof() && this.isPlasmaProof() == that.isPlasmaProof() && this.containmentPredicate.equals(that.containmentPredicate);
    }

    public int hashCode() {
        return Objects.hash(this.getThroughput(), this.getTanks(), this.getMaxFluidTemperature(), this.gasProof, this.cryoProof, this.plasmaProof, this.containmentPredicate);
    }

    public String toString() {
        return "FluidPipeProperties{throughput=" + this.throughput + ", tanks=" + this.tanks + ", maxFluidTemperature=" + this.maxFluidTemperature + ", gasProof=" + this.gasProof + ", cryoProof=" + this.cryoProof + ", plasmaProof=" + this.plasmaProof + ", containmentPredicate=" + this.containmentPredicate + '}';
    }
}

