/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.util;

import gregtech.api.terminal.util.ISearch;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class SearchEngine<T> {
    private final ISearch<T> search;
    private final Consumer<T> result;
    private Thread thread;

    public SearchEngine(@NotNull ISearch<T> search, @NotNull Consumer<T> result) {
        this.search = search;
        this.result = result;
    }

    public void searchWord(String word) {
        this.dispose();
        this.thread = new Thread(() -> this.search.search(word, this.result));
        this.thread.start();
    }

    public boolean isSearching() {
        return this.thread != null && this.thread.isAlive();
    }

    public void dispose() {
        if (this.isSearching()) {
            if (this.search.isManualInterrupt()) {
                this.thread.interrupt();
            } else {
                this.thread.stop();
            }
        }
        this.thread = null;
    }
}

