/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.hardware;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.items.metaitem.stats.IItemCapabilityProvider;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.hardware.Hardware;
import gregtech.api.terminal.hardware.IHardwareCapability;
import gregtech.common.items.behaviors.TerminalBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardwareProvider
implements ICapabilityProvider,
IItemCapabilityProvider {
    private Map<String, Hardware> providers;
    private Map<String, ItemStack> itemCache;
    private Boolean isCreative;
    private ItemStack itemStack;
    private NBTTagCompound tag;

    public void cleanCache(String name) {
        this.itemCache.remove(name);
    }

    public boolean isCreative() {
        if (this.isCreative == null) {
            this.isCreative = TerminalBehaviour.isCreative(this.getItemStack());
        }
        return this.isCreative;
    }

    public Map<String, Hardware> getProviders() {
        return this.providers;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public NBTTagCompound getOrCreateHardwareCompound() {
        if (this.tag == null) {
            NBTTagCompound terminal = this.itemStack.func_190925_c("terminal");
            if (!terminal.func_74764_b("_hw")) {
                terminal.func_74782_a("_hw", (NBTBase)new NBTTagCompound());
            }
            this.tag = terminal.func_74775_l("_hw");
        }
        return this.tag;
    }

    public List<Hardware> getHardware() {
        if (TerminalBehaviour.isCreative(this.itemStack)) {
            return new ArrayList<Hardware>(this.providers.values());
        }
        return this.getOrCreateHardwareCompound().func_150296_c().stream().map(this.providers::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean hasHardware(String name) {
        return this.itemStack != null && (TerminalBehaviour.isCreative(this.getItemStack()) || this.getOrCreateHardwareCompound().func_74764_b(name));
    }

    public NBTTagCompound getHardwareNBT(String name) {
        return this.getOrCreateHardwareCompound().func_74775_l(name);
    }

    public ItemStack getHardwareItem(String name) {
        if (!this.itemCache.containsKey(name)) {
            NBTTagCompound tag = this.getHardwareNBT(name);
            if (tag.func_74764_b("item")) {
                this.itemCache.put(name, new ItemStack(tag.func_74775_l("item")));
            } else {
                this.itemCache.put(name, ItemStack.field_190927_a);
            }
        }
        return this.itemCache.get(name);
    }

    @Override
    public ICapabilityProvider createProvider(ItemStack itemStack) {
        HardwareProvider provider = new HardwareProvider();
        provider.providers = new LinkedHashMap<String, Hardware>();
        provider.itemCache = new HashMap<String, ItemStack>();
        provider.itemStack = itemStack;
        for (Hardware hardware : TerminalRegistry.getAllHardware()) {
            Hardware instance = hardware.createHardware(itemStack);
            if (instance == null) continue;
            instance.provider = provider;
            provider.providers.put(hardware.getRegistryName(), instance);
        }
        return provider;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.providers != null) {
            for (Map.Entry<String, Hardware> entry : this.providers.entrySet()) {
                Hardware provider = entry.getValue();
                if (!(provider instanceof IHardwareCapability) || !this.hasHardware(entry.getKey()) || !((IHardwareCapability)((Object)provider)).hasCapability(capability)) continue;
                return true;
            }
        }
        return capability == GregtechCapabilities.CAPABILITY_HARDWARE_PROVIDER;
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.providers != null) {
            for (Map.Entry<String, Hardware> entry : this.providers.entrySet()) {
                Hardware provider = entry.getValue();
                if (!(provider instanceof IHardwareCapability) || !this.hasHardware(entry.getKey()) || !((IHardwareCapability)((Object)provider)).hasCapability(capability)) continue;
                return ((IHardwareCapability)((Object)provider)).getCapability(capability);
            }
        }
        return (T)(capability == GregtechCapabilities.CAPABILITY_HARDWARE_PROVIDER ? GregtechCapabilities.CAPABILITY_HARDWARE_PROVIDER.cast((Object)this) : null);
    }
}

